/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInspection.actions.InspectionListCellRenderer;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.gotoByName.SimpleChooseByNameModel;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ListCellRenderer;

public class GotoInspectionModel
extends SimpleChooseByNameModel {
    private final MultiMap<String, InspectionToolWrapper> myToolNames = MultiMap.createSmartList();
    private final Map<String, Set<InspectionToolWrapper>> myGroupNames = new HashMap<String, Set<InspectionToolWrapper>>();
    private final Map<String, InspectionToolWrapper> myToolShortNames = new HashMap<String, InspectionToolWrapper>();
    private final String[] myNames;
    private final ListCellRenderer myListCellRenderer = new InspectionListCellRenderer();

    public GotoInspectionModel(Project project) {
        super(project, IdeBundle.message((String)"prompt.goto.inspection.enter.name", (Object[])new Object[0]), "goto.inspection.help.id");
        InspectionProfileImpl rootProfile = (InspectionProfileImpl)InspectionProfileManager.getInstance().getRootProfile();
        for (ScopeToolState state : rootProfile.getAllTools(project)) {
            InspectionToolWrapper tool;
            InspectionToolWrapper workingTool = tool = state.getTool();
            if (tool instanceof LocalInspectionToolWrapper && (workingTool = LocalInspectionToolWrapper.findTool2RunInBatch(project, null, tool.getShortName())) == null) continue;
            this.myToolNames.putValue((Object)tool.getDisplayName(), (Object)workingTool);
            String groupName = tool.getGroupDisplayName();
            Set<InspectionToolWrapper> toolsInGroup = this.myGroupNames.get(groupName);
            if (toolsInGroup == null) {
                toolsInGroup = new HashSet<InspectionToolWrapper>();
                this.myGroupNames.put(groupName, toolsInGroup);
            }
            toolsInGroup.add(workingTool);
            this.myToolShortNames.put(tool.getShortName(), workingTool);
        }
        HashSet<String> nameIds = new HashSet<String>();
        nameIds.addAll(this.myToolNames.keySet());
        nameIds.addAll(this.myGroupNames.keySet());
        this.myNames = ArrayUtil.toStringArray(nameIds);
    }

    public ListCellRenderer getListCellRenderer() {
        return this.myListCellRenderer;
    }

    @Override
    public String[] getNames() {
        return this.myNames;
    }

    @Override
    public Object[] getElementsByName(String id, String pattern) {
        Set<InspectionToolWrapper> entries;
        HashSet<InspectionToolWrapper> result = new HashSet<InspectionToolWrapper>();
        result.addAll(this.myToolNames.get((Object)id));
        InspectionToolWrapper e = this.myToolShortNames.get(id);
        if (e != null) {
            result.add(e);
        }
        if ((entries = this.myGroupNames.get(id)) != null) {
            result.addAll(entries);
        }
        return result.toArray(new InspectionToolWrapper[result.size()]);
    }

    public String getElementName(Object element) {
        if (element instanceof InspectionToolWrapper) {
            InspectionToolWrapper entry = (InspectionToolWrapper)element;
            return entry.getDisplayName() + " " + entry.getGroupDisplayName();
        }
        return null;
    }
}

