/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.IntArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class StreamApiMigrationInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)("#" + StreamApiMigrationInspection.class.getName()));

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("foreach loop can be collapsed with stream api" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getDisplayName"));
        }
        return "foreach loop can be collapsed with stream api";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("Convert2streamapi" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getShortName"));
        }
        return "Convert2streamapi";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/StreamApiMigrationInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitForeachStatement(PsiForeachStatement statement) {
                super.visitForeachStatement(statement);
                if (PsiUtil.getLanguageLevel((PsiElement)statement).isAtLeast(LanguageLevel.JDK_1_8)) {
                    PsiType iteratedValueType;
                    PsiExpression iteratedValue = statement.getIteratedValue();
                    final PsiStatement body = statement.getBody();
                    if (iteratedValue != null && body != null && InheritanceUtil.isInheritor((PsiType)(iteratedValueType = iteratedValue.getType()), (String)"java.util.Collection")) {
                        PsiClass iteratorClass = PsiUtil.resolveClassInType((PsiType)iteratedValueType);
                        LOG.assertTrue(iteratorClass != null);
                        try {
                            ControlFlow controlFlow = ControlFlowFactory.getInstance(holder.getProject()).getControlFlow((PsiElement)body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                            int startOffset = controlFlow.getStartOffset((PsiElement)body);
                            int endOffset = controlFlow.getEndOffset((PsiElement)body);
                            Collection<PsiStatement> exitPoints = ControlFlowUtil.findExitPointsAndStatements(controlFlow, startOffset, endOffset, new IntArrayList(), PsiContinueStatement.class, PsiBreakStatement.class, PsiReturnStatement.class, PsiThrowStatement.class);
                            if (exitPoints.isEmpty()) {
                                final boolean[] effectivelyFinal = new boolean[]{true};
                                body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                                    public void visitElement(PsiElement element) {
                                        if (!effectivelyFinal[0]) {
                                            return;
                                        }
                                        super.visitElement(element);
                                    }

                                    public void visitReferenceExpression(PsiReferenceExpression expression) {
                                        if (!effectivelyFinal[0]) {
                                            return;
                                        }
                                        super.visitReferenceExpression(expression);
                                        PsiElement resolve = expression.resolve();
                                        if (resolve instanceof PsiVariable && !(resolve instanceof PsiField)) {
                                            effectivelyFinal[0] = HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)resolve, (PsiElement)body, (PsiJavaCodeReferenceElement)expression);
                                        }
                                    }
                                });
                                if (effectivelyFinal[0]) {
                                    if (StreamApiMigrationInspection.isCollectCall(body)) {
                                        holder.registerProblem((PsiElement)iteratedValue, "Can be replaced with collect call", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithCollectCallFix()});
                                    } else if (!StreamApiMigrationInspection.isTrivial(body, statement.getIterationParameter(), iteratedValueType)) {
                                        holder.registerProblem((PsiElement)iteratedValue, "Can be replaced with foreach call", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithForeachCallFix()});
                                    }
                                }
                            }
                        }
                        catch (AnalysisCanceledException ignored) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean isCollectCall(PsiStatement body) {
        PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
        PsiMethodCallExpression methodCallExpression = StreamApiMigrationInspection.extractAddCall(body);
        if (methodCallExpression != null) {
            PsiClass enclosingClass;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            PsiClass qualifierClass = null;
            if (qualifierExpression instanceof PsiReferenceExpression) {
                qualifierClass = PsiUtil.resolveClassInType((PsiType)qualifierExpression.getType());
            } else if (qualifierExpression == null && PsiUtil.getEnclosingStaticElement((PsiElement)body, (PsiClass)(enclosingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)body, PsiClass.class))) == null) {
                qualifierClass = enclosingClass;
            }
            if (qualifierClass != null && InheritanceUtil.isInheritor((PsiClass)qualifierClass, (boolean)false, (String)"java.util.Collection")) {
                PsiExpression[] args;
                PsiExpression condition;
                if (ifStatement != null && (condition = ifStatement.getCondition()) != null && StreamApiMigrationInspection.isConditionDependsOnUpdatedCollections(condition, qualifierExpression)) {
                    return false;
                }
                PsiElement resolve = methodExpression.resolve();
                if (resolve instanceof PsiMethod && "add".equals(((PsiMethod)resolve).getName()) && ((PsiMethod)resolve).getParameterList().getParametersCount() == 1 && (args = methodCallExpression.getArgumentList().getExpressions()).length == 1) {
                    if (args[0] instanceof PsiCallExpression) {
                        PsiMethod method = ((PsiCallExpression)args[0]).resolveMethod();
                        return method != null && !method.hasTypeParameters();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isConditionDependsOnUpdatedCollections(PsiExpression condition, PsiExpression qualifierExpression) {
        final PsiElement collection = qualifierExpression != null ? ((PsiReferenceExpression)qualifierExpression).resolve() : null;
        final boolean[] dependsOnCollection = new boolean[]{false};
        condition.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                if (collection != null && collection == expression.resolve()) {
                    dependsOnCollection[0] = true;
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiExpression callQualifier = expression.getMethodExpression().getQualifierExpression();
                if (collection == callQualifier) {
                    dependsOnCollection[0] = true;
                }
                if (collection == null && (callQualifier instanceof PsiThisExpression && ((PsiThisExpression)callQualifier).getQualifier() == null || callQualifier instanceof PsiSuperExpression && ((PsiSuperExpression)callQualifier).getQualifier() == null)) {
                    dependsOnCollection[0] = true;
                }
            }

            public void visitThisExpression(PsiThisExpression expression) {
                super.visitThisExpression(expression);
                if (collection == null && expression.getQualifier() == null && expression.getParent() instanceof PsiExpressionList) {
                    dependsOnCollection[0] = true;
                }
            }

            public void visitClass(PsiClass aClass) {
            }
        });
        return dependsOnCollection[0];
    }

    private static boolean isTrivial(PsiStatement body, PsiParameter parameter, PsiType iteratedValueType) {
        PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
        if (ifStatement != null && InheritanceUtil.isInheritor((PsiType)iteratedValueType, (String)"java.util.Collection")) {
            return false;
        }
        return LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiElement)(body instanceof PsiBlockStatement ? ((PsiBlockStatement)body).getCodeBlock() : body), new PsiParameter[]{parameter}, null) == null;
    }

    public static PsiIfStatement extractIfStatement(PsiStatement body) {
        PsiStatement[] statements;
        PsiIfStatement ifStmt = null;
        if (body instanceof PsiIfStatement) {
            ifStmt = (PsiIfStatement)body;
        } else if (body instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)body).getCodeBlock().getStatements()).length == 1 && statements[0] instanceof PsiIfStatement) {
            ifStmt = (PsiIfStatement)statements[0];
        }
        if (ifStmt != null && ifStmt.getElseBranch() == null && ifStmt.getThenBranch() != null) {
            return ifStmt;
        }
        return null;
    }

    private static PsiMethodCallExpression extractAddCall(PsiStatement body) {
        PsiExpression expression;
        PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
        if (ifStatement != null) {
            return StreamApiMigrationInspection.extractAddCall(ifStatement.getThenBranch());
        }
        PsiExpressionStatement stmt = null;
        if (body instanceof PsiBlockStatement) {
            PsiStatement[] statements = ((PsiBlockStatement)body).getCodeBlock().getStatements();
            if (statements.length == 1 && statements[0] instanceof PsiExpressionStatement) {
                stmt = (PsiExpressionStatement)statements[0];
            }
        } else if (body instanceof PsiExpressionStatement) {
            stmt = (PsiExpressionStatement)body;
        }
        if (stmt != null && (expression = stmt.getExpression()) instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)expression;
        }
        return null;
    }

    private static class ReplaceWithCollectCallFix
    implements LocalQuickFix {
        private ReplaceWithCollectCallFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectCallFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with collect" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectCallFix", "getFamilyName"));
            }
            return "Replace with collect";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectCallFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectCallFix", "applyFix"));
            }
            PsiForeachStatement foreachStatement = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiForeachStatement.class);
            if (foreachStatement != null) {
                PsiStatement body = foreachStatement.getBody();
                PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                if (body != null && iteratedValue != null) {
                    PsiExpression mapperCall;
                    PsiExpression condition;
                    PsiParameter parameter = foreachStatement.getIterationParameter();
                    PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
                    PsiMethodCallExpression methodCallExpression = StreamApiMigrationInspection.extractAddCall(body);
                    String iteration = iteratedValue.getText() + ".stream()";
                    if (ifStatement != null && (condition = ifStatement.getCondition()) != null) {
                        iteration = iteration + ".filter(" + parameter.getName() + " -> " + condition.getText() + ")";
                    }
                    if (!ReplaceWithCollectCallFix.isIdentityMapping(parameter, mapperCall = methodCallExpression.getArgumentList().getExpressions()[0])) {
                        iteration = iteration + ".map(";
                        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                        PsiClass functionClass = psiFacade.findClass("java.util.function.Function", GlobalSearchScope.allScope((Project)project));
                        PsiClassType functionalInterfaceType = functionClass != null ? psiFacade.getElementFactory().createType(functionClass, new PsiType[]{parameter.getType(), mapperCall.getType()}) : null;
                        PsiCallExpression toConvertCall = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiElement)mapperCall, new PsiParameter[]{parameter}, functionalInterfaceType);
                        String methodReferenceText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText((PsiElement)toConvertCall, (PsiType)functionalInterfaceType, new PsiParameter[]{parameter});
                        iteration = methodReferenceText != null ? iteration + methodReferenceText : iteration + parameter.getName() + " -> " + mapperCall.getText();
                        iteration = iteration + ")";
                    }
                    iteration = iteration + ".collect(java.util.stream.Collectors.";
                    String variableName = null;
                    PsiExpression primitiveInitializer = null;
                    PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
                    if (qualifierExpression instanceof PsiReferenceExpression) {
                        PsiElement resolve = ((PsiReferenceExpression)qualifierExpression).resolve();
                        if (resolve instanceof PsiVariable) {
                            PsiExpressionList argumentList;
                            PsiExpression initializer;
                            if (resolve instanceof PsiLocalVariable && foreachStatement.equals(PsiTreeUtil.skipSiblingsForward((PsiElement)resolve.getParent(), (Class[])new Class[]{PsiWhiteSpace.class})) && (initializer = ((PsiVariable)resolve).getInitializer()) instanceof PsiNewExpression && (argumentList = ((PsiNewExpression)initializer).getArgumentList()) != null && argumentList.getExpressions().length == 0) {
                                primitiveInitializer = initializer;
                            }
                            variableName = qualifierExpression.getText() + ".";
                        }
                    } else if (qualifierExpression == null) {
                        variableName = "";
                    }
                    if (variableName != null) {
                        PsiElement parent = foreachStatement.getParent();
                        for (PsiComment comment : PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiComment.class)) {
                            parent.addBefore((PsiElement)comment, (PsiElement)foreachStatement);
                        }
                    }
                    PsiElement result = null;
                    if (primitiveInitializer != null) {
                        PsiClassType rawType;
                        PsiType initializerType = primitiveInitializer.getType();
                        PsiClassType psiClassType = rawType = initializerType instanceof PsiClassType ? ((PsiClassType)initializerType).rawType() : null;
                        iteration = rawType != null && rawType.equalsToText("java.util.ArrayList") ? iteration + "toList()" : (rawType != null && rawType.equalsToText("java.util.HashSet") ? iteration + "toSet()" : iteration + "toCollection(() -> " + primitiveInitializer.getText() + ")");
                        iteration = iteration + ")";
                        result = primitiveInitializer.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(iteration, (PsiElement)foreachStatement));
                        foreachStatement.delete();
                    } else if (variableName != null) {
                        iteration = iteration + "toList())";
                        result = foreachStatement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(variableName + "addAll(" + iteration + ");", (PsiElement)foreachStatement));
                    }
                    if (result != null) {
                        result = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
                    }
                }
            }
        }

        private static boolean isIdentityMapping(PsiParameter parameter, PsiExpression mapperCall) {
            return mapperCall instanceof PsiReferenceExpression && ((PsiReferenceExpression)mapperCall).resolve() == parameter;
        }
    }

    private static class ReplaceWithForeachCallFix
    implements LocalQuickFix {
        private ReplaceWithForeachCallFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with forEach" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "getFamilyName"));
            }
            return "Replace with forEach";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "applyFix"));
            }
            PsiForeachStatement foreachStatement = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiForeachStatement.class);
            if (foreachStatement != null) {
                PsiStatement body = foreachStatement.getBody();
                PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                if (body != null && iteratedValue != null) {
                    PsiExpression condition;
                    String iterated;
                    Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiComment.class);
                    PsiElement parent = foreachStatement.getParent();
                    for (PsiComment comment : PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiComment.class)) {
                        parent.addBefore((PsiElement)comment, (PsiElement)foreachStatement);
                    }
                    PsiParameter parameter = foreachStatement.getIterationParameter();
                    PsiIfStatement ifStmt = StreamApiMigrationInspection.extractIfStatement(body);
                    String foreEachText = ReplaceWithForeachCallFix.wrapInBlock(body);
                    String string = iterated = iteratedValue instanceof PsiCallExpression || iteratedValue instanceof PsiReferenceExpression || iteratedValue instanceof PsiQualifiedExpression || iteratedValue instanceof PsiParenthesizedExpression ? iteratedValue.getText() : "(" + iteratedValue.getText() + ")";
                    if (ifStmt != null && (condition = ifStmt.getCondition()) != null) {
                        PsiStatement thenBranch = ifStmt.getThenBranch();
                        LOG.assertTrue(thenBranch != null);
                        if (InheritanceUtil.isInheritor((PsiType)iteratedValue.getType(), (String)"java.util.Collection")) {
                            body = thenBranch;
                            foreEachText = ReplaceWithForeachCallFix.wrapInBlock(thenBranch);
                            iterated = iterated + ".stream().filter(" + parameter.getName() + " -> " + condition.getText() + ")";
                        }
                    }
                    PsiParameter[] parameters = new PsiParameter[]{parameter};
                    String methodReferenceText = null;
                    PsiCallExpression callExpression = LambdaCanBeMethodReferenceInspection.extractMethodCallFromBlock((PsiElement)body);
                    if (callExpression != null) {
                        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                        PsiClass consumerClass = psiFacade.findClass("java.util.function.Consumer", GlobalSearchScope.allScope((Project)project));
                        PsiClassType functionalType = consumerClass != null ? psiFacade.getElementFactory().createType(consumerClass, callExpression.getType()) : null;
                        PsiCallExpression toConvertCall = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiElement)(body instanceof PsiBlockStatement ? ((PsiBlockStatement)body).getCodeBlock() : body), parameters, (PsiType)functionalType);
                        methodReferenceText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText((PsiElement)toConvertCall, (PsiType)functionalType, parameters);
                    }
                    String lambdaText = parameter.getName() + " -> " + foreEachText;
                    String codeBlock8 = methodReferenceText != null ? methodReferenceText : lambdaText;
                    PsiExpressionStatement callStatement = (PsiExpressionStatement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(iterated + ".forEach(" + codeBlock8 + ");", (PsiElement)foreachStatement);
                    callStatement = (PsiExpressionStatement)foreachStatement.replace((PsiElement)callStatement);
                    PsiExpressionList argumentList = ((PsiCallExpression)callStatement.getExpression()).getArgumentList();
                    LOG.assertTrue(argumentList != null, (Object)callStatement.getText());
                    PsiExpression[] expressions = argumentList.getExpressions();
                    LOG.assertTrue(expressions.length == 1);
                    if (expressions[0] instanceof PsiLambdaExpression && ((PsiLambdaExpression)expressions[0]).getFunctionalInterfaceType() == null || expressions[0] instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)expressions[0]).getFunctionalInterfaceType() == null) {
                        callStatement = (PsiExpressionStatement)callStatement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(iterated + ".forEach((" + parameter.getText() + ") -> " + foreEachText + ");", (PsiElement)callStatement));
                    }
                }
            }
        }

        private static String wrapInBlock(PsiStatement body) {
            if (body instanceof PsiExpressionStatement) {
                return ((PsiExpressionStatement)body).getExpression().getText();
            }
            String bodyText = body.getText();
            if (!(body instanceof PsiBlockStatement)) {
                return "{" + bodyText + "}";
            }
            return bodyText;
        }
    }
}

