/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import javax.annotation.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSuppressionUtil {
    public static final String SUPPRESS_INSPECTIONS_ANNOTATION_NAME = "java.lang.SuppressWarnings";

    public static boolean alreadyHas14Suppressions(@NotNull PsiDocCommentOwner commentOwner) {
        if (commentOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/JavaSuppressionUtil", "alreadyHas14Suppressions"));
        }
        PsiDocComment docComment = commentOwner.getDocComment();
        return docComment != null && docComment.findTagByName("noinspection") != null;
    }

    @Nullable
    public static String getInspectionIdSuppressedInAnnotationAttribute(PsiElement element) {
        Object val;
        PsiElement psiElement;
        if (element instanceof PsiLiteralExpression) {
            Object value = ((PsiLiteralExpression)element).getValue();
            if (value instanceof String) {
                return (String)value;
            }
        } else if (element instanceof PsiReferenceExpression && (psiElement = ((PsiReferenceExpression)element).resolve()) instanceof PsiVariableEx && (val = ((PsiVariableEx)psiElement).computeConstantValue(new HashSet<PsiVariable>())) instanceof String) {
            return (String)val;
        }
        return null;
    }

    @NotNull
    public static Collection<String> getInspectionIdsSuppressedInAnnotation(PsiModifierList modifierList) {
        if (modifierList == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/JavaSuppressionUtil", "getInspectionIdsSuppressedInAnnotation"));
            }
            return list;
        }
        PsiModifierListOwner owner = (PsiModifierListOwner)modifierList.getParent();
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{SUPPRESS_INSPECTIONS_ANNOTATION_NAME});
        if (annotation == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/JavaSuppressionUtil", "getInspectionIdsSuppressedInAnnotation"));
            }
            return list;
        }
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        if (attributes.length == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/JavaSuppressionUtil", "getInspectionIdsSuppressedInAnnotation"));
            }
            return list;
        }
        PsiAnnotationMemberValue attributeValue = attributes[0].getValue();
        ArrayList<String> result = new ArrayList<String>();
        if (attributeValue instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers;
            for (PsiAnnotationMemberValue annotationMemberValue : initializers = ((PsiArrayInitializerMemberValue)attributeValue).getInitializers()) {
                String id = JavaSuppressionUtil.getInspectionIdSuppressedInAnnotationAttribute((PsiElement)annotationMemberValue);
                if (id == null) continue;
                result.add(id);
            }
        } else {
            String id = JavaSuppressionUtil.getInspectionIdSuppressedInAnnotationAttribute((PsiElement)attributeValue);
            if (id != null) {
                result.add(id);
            }
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/JavaSuppressionUtil", "getInspectionIdsSuppressedInAnnotation"));
        }
        return arrayList;
    }

    public static PsiElement getElementMemberSuppressedIn(@NotNull PsiDocCommentOwner owner, String inspectionToolID) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/JavaSuppressionUtil", "getElementMemberSuppressedIn"));
        }
        PsiElement element = JavaSuppressionUtil.getDocCommentToolSuppressedIn(owner, inspectionToolID);
        if (element != null) {
            return element;
        }
        element = JavaSuppressionUtil.getAnnotationMemberSuppressedIn((PsiModifierListOwner)owner, inspectionToolID);
        if (element != null) {
            return element;
        }
        PsiDocCommentOwner classContainer = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiDocCommentOwner.class);
        while (classContainer != null) {
            element = JavaSuppressionUtil.getDocCommentToolSuppressedIn(classContainer, inspectionToolID);
            if (element != null) {
                return element;
            }
            element = JavaSuppressionUtil.getAnnotationMemberSuppressedIn((PsiModifierListOwner)classContainer, inspectionToolID);
            if (element != null) {
                return element;
            }
            classContainer = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)classContainer, PsiDocCommentOwner.class);
        }
        return null;
    }

    static PsiElement getAnnotationMemberSuppressedIn(@NotNull PsiModifierListOwner owner, String inspectionToolID) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/JavaSuppressionUtil", "getAnnotationMemberSuppressedIn"));
        }
        PsiAnnotation generatedAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{Generated.class.getName()});
        if (generatedAnnotation != null) {
            return generatedAnnotation;
        }
        PsiModifierList modifierList = owner.getModifierList();
        Collection<String> suppressedIds = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(modifierList);
        for (String ids : suppressedIds) {
            if (!SuppressionUtil.isInspectionToolIdMentioned(ids, inspectionToolID)) continue;
            return modifierList != null ? AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{SUPPRESS_INSPECTIONS_ANNOTATION_NAME}) : null;
        }
        return null;
    }

    static PsiElement getDocCommentToolSuppressedIn(@NotNull PsiDocCommentOwner owner, String inspectionToolID) {
        PsiDocTag inspectionTag;
        PsiElement el;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/JavaSuppressionUtil", "getDocCommentToolSuppressedIn"));
        }
        PsiDocComment docComment = owner.getDocComment();
        if (docComment == null && owner.getParent() instanceof PsiDeclarationStatement && (el = PsiTreeUtil.skipSiblingsBackward((PsiElement)owner.getParent(), (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiDocComment) {
            docComment = (PsiDocComment)el;
        }
        if (docComment != null && (inspectionTag = docComment.findTagByName("noinspection")) != null) {
            PsiElement[] dataElements;
            for (PsiElement dataElement : dataElements = inspectionTag.getDataElements()) {
                String valueText = dataElement.getText();
                if (!SuppressionUtil.isInspectionToolIdMentioned(valueText, inspectionToolID)) continue;
                return docComment;
            }
        }
        return null;
    }

    public static Collection<String> getInspectionIdsSuppressedInAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/JavaSuppressionUtil", "getInspectionIdsSuppressedInAnnotation"));
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)owner)) {
            return Collections.emptyList();
        }
        PsiModifierList modifierList = owner.getModifierList();
        return JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(modifierList);
    }

    public static String getSuppressedInspectionIdsIn(@NotNull PsiElement element) {
        PsiDocTag inspectionTag;
        PsiDocComment docComment;
        String text;
        Matcher matcher;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/JavaSuppressionUtil", "getSuppressedInspectionIdsIn"));
        }
        if (element instanceof PsiComment && (matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text = element.getText())).matches()) {
            return matcher.group(1).trim();
        }
        if (element instanceof PsiDocCommentOwner && (docComment = ((PsiDocCommentOwner)element).getDocComment()) != null && (inspectionTag = docComment.findTagByName("noinspection")) != null) {
            String valueText = "";
            for (PsiElement dataElement : inspectionTag.getDataElements()) {
                valueText = valueText + dataElement.getText();
            }
            return valueText;
        }
        if (element instanceof PsiModifierListOwner) {
            Collection<String> suppressedIds = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation((PsiModifierListOwner)element);
            return suppressedIds.isEmpty() ? null : StringUtil.join(suppressedIds, (String)",");
        }
        return null;
    }

    static PsiElement getElementToolSuppressedIn(final @NotNull PsiElement place, final String toolId) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/JavaSuppressionUtil", "getElementToolSuppressedIn"));
        }
        if (place instanceof PsiFile) {
            return null;
        }
        return (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiElement>(){

            @Nullable
            public PsiElement compute() {
                PsiElement element;
                PsiElement element2;
                PsiElement statement = SuppressionUtil.getStatementToolSuppressedIn(place, toolId, PsiStatement.class);
                if (statement != null) {
                    return statement;
                }
                PsiVariable local = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)place, PsiVariable.class, (boolean)false);
                if (local != null && JavaSuppressionUtil.getAnnotationMemberSuppressedIn((PsiModifierListOwner)local, toolId) != null) {
                    PsiModifierList modifierList = local.getModifierList();
                    return modifierList != null ? modifierList.findAnnotation(JavaSuppressionUtil.SUPPRESS_INSPECTIONS_ANNOTATION_NAME) : null;
                }
                PsiDocCommentOwner container = (PsiDocCommentOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiDocCommentOwner.class});
                while (container instanceof PsiTypeParameter) {
                    container = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)container, PsiDocCommentOwner.class);
                }
                if (container != null && (element2 = JavaSuppressionUtil.getElementMemberSuppressedIn(container, toolId)) != null) {
                    return element2;
                }
                PsiDocCommentOwner classContainer = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)container, PsiDocCommentOwner.class, (boolean)true);
                if (classContainer != null && (element = JavaSuppressionUtil.getElementMemberSuppressedIn(classContainer, toolId)) != null) {
                    return element;
                }
                return null;
            }
        });
    }

    public static void addSuppressAnnotation(@NotNull Project project, PsiElement container, PsiModifierListOwner modifierOwner, @NotNull String id) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/JavaSuppressionUtil", "addSuppressAnnotation"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/JavaSuppressionUtil", "addSuppressAnnotation"));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierOwner, (String[])new String[]{SUPPRESS_INSPECTIONS_ANNOTATION_NAME});
        PsiAnnotation newAnnotation = JavaSuppressionUtil.createNewAnnotation(project, container, annotation, id);
        if (newAnnotation != null) {
            if (annotation != null && annotation.isPhysical()) {
                annotation.replace((PsiElement)newAnnotation);
            } else {
                PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
                new AddAnnotationPsiFix(SUPPRESS_INSPECTIONS_ANNOTATION_NAME, modifierOwner, attributes, new String[0]).applyFix();
            }
        }
    }

    private static PsiAnnotation createNewAnnotation(@NotNull Project project, PsiElement container, PsiAnnotation annotation, @NotNull String id) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/JavaSuppressionUtil", "createNewAnnotation"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/JavaSuppressionUtil", "createNewAnnotation"));
        }
        if (annotation == null) {
            return JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@java.lang.SuppressWarnings(\"" + id + "\")", container);
        }
        String currentSuppressedId = "\"" + id + "\"";
        if (!annotation.getText().contains("{")) {
            PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
            if (attributes.length == 1) {
                String suppressedWarnings = attributes[0].getText();
                if (suppressedWarnings.contains(currentSuppressedId)) {
                    return null;
                }
                return JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@java.lang.SuppressWarnings({" + suppressedWarnings + ", " + currentSuppressedId + "})", container);
            }
        } else {
            int curlyBraceIndex = annotation.getText().lastIndexOf("}");
            if (curlyBraceIndex > 0) {
                String oldSuppressWarning = annotation.getText().substring(0, curlyBraceIndex);
                if (oldSuppressWarning.contains(currentSuppressedId)) {
                    return null;
                }
                return JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(oldSuppressWarning + ", " + currentSuppressedId + "})", container);
            }
            throw new IncorrectOperationException(annotation.getText());
        }
        return null;
    }

    public static boolean canHave15Suppressions(@NotNull PsiElement file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/JavaSuppressionUtil", "canHave15Suppressions"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return false;
        }
        Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (jdk == null) {
            return false;
        }
        JavaSdkVersion version = JavaSuppressionUtil.getVersion(jdk);
        if (version == null) {
            return false;
        }
        boolean is_1_5 = version.isAtLeast(JavaSdkVersion.JDK_1_5);
        return DaemonCodeAnalyzerSettings.getInstance().isSuppressWarnings() && is_1_5 && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Nullable
    private static JavaSdkVersion getVersion(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/JavaSuppressionUtil", "getVersion"));
        }
        String version = sdk.getVersionString();
        if (version == null) {
            return null;
        }
        return JdkVersionUtil.getVersion((String)version);
    }

    @Nullable
    public static PsiElement getElementToAnnotate(PsiElement element, PsiElement container) {
        if (container instanceof PsiDeclarationStatement && JavaSuppressionUtil.canHave15Suppressions(element)) {
            PsiElement[] declaredElements;
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)container;
            for (PsiElement declaredElement : declaredElements = declarationStatement.getDeclaredElements()) {
                PsiModifierList modifierList;
                if (!(declaredElement instanceof PsiLocalVariable) || (modifierList = ((PsiLocalVariable)declaredElement).getModifierList()) == null) continue;
                return declaredElement;
            }
        }
        return null;
    }
}

