/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.BooleanPostfixTemplate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiWhileStatement;
import org.jetbrains.annotations.NotNull;

public class WhileStatementPostfixTemplate
extends BooleanPostfixTemplate {
    public WhileStatementPostfixTemplate() {
        super("while", "Iterating while boolean statement is 'true'", "while (expr)");
    }

    @Override
    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        PsiJavaToken parenth;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/WhileStatementPostfixTemplate", "expand"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/WhileStatementPostfixTemplate", "expand"));
        }
        PsiExpression expression = WhileStatementPostfixTemplate.getTopmostExpression(context);
        assert (expression != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        PsiWhileStatement whileStatement = (PsiWhileStatement)factory.createStatementFromText("while(expr)", context);
        PsiExpression condition = whileStatement.getCondition();
        assert (condition != null);
        condition.replace((PsiElement)expression);
        PsiElement replacedWhileStatement = expression.replace((PsiElement)whileStatement);
        if (replacedWhileStatement instanceof PsiWhileStatement && (parenth = ((PsiWhileStatement)replacedWhileStatement).getRParenth()) != null) {
            editor.getCaretModel().moveToOffset(parenth.getTextRange().getEndOffset());
        }
    }
}

