/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplate {
    @NotNull
    private final String myPresentableName;
    @NotNull
    private final String myKey;
    @NotNull
    private final String myDescription;
    @NotNull
    private final String myExample;
    @NotNull
    public static final ExtensionPointName<PostfixTemplate> EP_NAME = ExtensionPointName.create((String)"com.intellij.postfixTemplate");

    protected PostfixTemplate(@NotNull String name, @NotNull String description, @NotNull String example) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "<init>"));
        }
        if (example == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "<init>"));
        }
        this(name, "." + name, description, example);
    }

    protected PostfixTemplate(@NotNull String name, @NotNull String key, @NotNull String description, @NotNull String example) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "<init>"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "<init>"));
        }
        if (example == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "<init>"));
        }
        this.myPresentableName = name;
        this.myKey = key;
        this.myDescription = description;
        this.myExample = example;
    }

    @NotNull
    public final String getKey() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "getKey"));
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getExample() {
        String string = this.myExample;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "getExample"));
        }
        return string;
    }

    public boolean isEnabled() {
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        return settings != null && settings.isPostfixTemplatesEnabled() && settings.isTemplateEnabled(this);
    }

    @Nullable
    public static PsiExpression getTopmostExpression(PsiElement context) {
        PsiExpressionStatement statement = (PsiExpressionStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiExpressionStatement.class});
        return statement != null ? (PsiExpression)PsiTreeUtil.getChildOfType((PsiElement)statement, PsiExpression.class) : null;
    }

    public abstract boolean isApplicable(@NotNull PsiElement var1, @NotNull Document var2, int var3);

    public abstract void expand(@NotNull PsiElement var1, @NotNull Editor var2);
}

