/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.Aliases;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixLiveTemplate
extends CustomLiveTemplateBase {
    public static final String POSTFIX_TEMPLATE_ID = "POSTFIX_TEMPLATE_ID";
    private static final Logger LOG = Logger.getInstance(PostfixLiveTemplate.class);
    private final HashMap<String, PostfixTemplate> myTemplates = ContainerUtil.newHashMap();

    public PostfixLiveTemplate() {
        for (PostfixTemplate template : (PostfixTemplate[])PostfixTemplate.EP_NAME.getExtensions()) {
            this.register(template.getKey(), template);
            Aliases aliases = template.getClass().getAnnotation(Aliases.class);
            if (aliases == null) continue;
            for (String key : aliases.value()) {
                this.register(key, template);
            }
        }
    }

    private void register(@NotNull String key, @NotNull PostfixTemplate template) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "register"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "register"));
        }
        PostfixTemplate registered = this.myTemplates.put(key, template);
        if (registered != null) {
            LOG.error("Can't register postfix template. Duplicated key: " + template.getKey());
        }
    }

    @Override
    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "computeTemplateKey"));
        }
        Editor editor = callback.getEditor();
        String key = this.computeTemplateKeyWithoutContextChecking(editor.getDocument().getCharsSequence(), editor.getCaretModel().getOffset());
        if (key == null) {
            return null;
        }
        return PostfixLiveTemplate.isApplicableTemplate(this.getTemplateByKey(key), key, callback.getContext().getContainingFile(), editor) ? key : null;
    }

    @Override
    @Nullable
    public String computeTemplateKeyWithoutContextChecking(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "computeTemplateKeyWithoutContextChecking"));
        }
        Editor editor = callback.getEditor();
        return this.computeTemplateKeyWithoutContextChecking(editor.getDocument().getCharsSequence(), editor.getCaretModel().getOffset());
    }

    @Override
    public boolean supportsMultiCaret() {
        return false;
    }

    @Nullable
    public String computeTemplateKeyWithoutContextChecking(@NotNull CharSequence documentContent, int currentOffset) {
        int startOffset;
        if (documentContent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "computeTemplateKeyWithoutContextChecking"));
        }
        if (documentContent.length() < startOffset) {
            return null;
        }
        for (startOffset = currentOffset; startOffset > 0; --startOffset) {
            char currentChar = documentContent.charAt(startOffset - 1);
            if (Character.isJavaIdentifierPart(currentChar)) continue;
            if (currentChar != '.' && currentChar != '!') {
                return null;
            }
            --startOffset;
            break;
        }
        return String.valueOf(documentContent.subSequence(startOffset, currentOffset));
    }

    @Override
    public void expand(@NotNull String key, @NotNull CustomTemplateCallback callback) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "expand"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "expand"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.postfix");
        PostfixTemplate template = this.getTemplateByKey(key);
        Editor editor = callback.getEditor();
        PsiFile file = callback.getContext().getContainingFile();
        if (PostfixLiveTemplate.isApplicableTemplate(template, key, file, editor)) {
            int currentOffset = editor.getCaretModel().getOffset();
            PsiElement newContext = PostfixLiveTemplate.deleteTemplateKey(file, editor.getDocument(), currentOffset, key);
            newContext = PostfixLiveTemplate.addSemicolonIfNeeded(editor, editor.getDocument(), newContext, currentOffset - key.length());
            PostfixLiveTemplate.expandTemplate(template, editor, newContext);
        } else if (editor.getCaretModel().getAllCarets().size() == 1) {
            LOG.error("Template not found by key: " + key);
        }
    }

    @Override
    public boolean isApplicable(PsiFile file, int offset, boolean wrapping) {
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        if (wrapping || file == null || settings == null || !settings.isPostfixTemplatesEnabled() || PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset) != JavaLanguage.INSTANCE) {
            return false;
        }
        return StringUtil.isNotEmpty((String)this.computeTemplateKeyWithoutContextChecking(file.getText(), offset + 1));
    }

    @Override
    public boolean supportsWrapping() {
        return false;
    }

    @Override
    public void wrap(@NotNull String selection, @NotNull CustomTemplateCallback callback) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "wrap"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "wrap"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getTitle() {
        if ("Postfix" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "getTitle"));
        }
        return "Postfix";
    }

    @Override
    public char getShortcut() {
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        return settings != null ? (char)settings.getShortcut() : (char)'\t';
    }

    @Override
    public boolean hasCompletionItem(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "hasCompletionItem"));
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<? extends CustomLiveTemplateLookupElement> getLookupElements(@NotNull PsiFile file, @NotNull Editor editor, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "getLookupElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "getLookupElements"));
        }
        String key = this.computeTemplateKeyWithoutContextChecking(editor.getDocument().getCharsSequence(), offset);
        if (key != null && editor.getCaretModel().getCaretCount() == 1) {
            HashMap result = ContainerUtil.newHashMap();
            Condition<PostfixTemplate> isApplicationTemplateFunction = PostfixLiveTemplate.createIsApplicationTemplateFunction(key, file, editor);
            for (Map.Entry<String, PostfixTemplate> entry : this.myTemplates.entrySet()) {
                PostfixTemplate postfixTemplate = entry.getValue();
                if (!entry.getKey().startsWith(key) || !isApplicationTemplateFunction.value((Object)postfixTemplate)) continue;
                result.put(postfixTemplate.getKey(), new PostfixTemplateLookupElement(this, postfixTemplate, postfixTemplate.getKey(), false));
            }
            Collection collection = result.values();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "getLookupElements"));
            }
            return collection;
        }
        Collection<? extends CustomLiveTemplateLookupElement> collection = super.getLookupElements(file, editor, offset);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "getLookupElements"));
        }
        return collection;
    }

    @NotNull
    public Set<String> getAllTemplateKeys() {
        Set<String> set = this.myTemplates.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "getAllTemplateKeys"));
        }
        return set;
    }

    @Nullable
    public PostfixTemplate getTemplateByKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "getTemplateByKey"));
        }
        return this.myTemplates.get(key);
    }

    private static void expandTemplate(final @NotNull PostfixTemplate template, final @NotNull Editor editor, final @NotNull PsiElement context) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "expandTemplate"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "expandTemplate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "expandTemplate"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(context.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        template.expand(context, editor);
                    }
                }, "Expand postfix template", (Object)PostfixLiveTemplate.POSTFIX_TEMPLATE_ID);
            }
        });
    }

    @Contract(value="null, _, _, _ -> false")
    private static boolean isApplicableTemplate(@Nullable PostfixTemplate template, @NotNull String key, @NotNull PsiFile file, @NotNull Editor editor) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "isApplicableTemplate"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "isApplicableTemplate"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "isApplicableTemplate"));
        }
        return PostfixLiveTemplate.createIsApplicationTemplateFunction(key, file, editor).value((Object)template);
    }

    private static Condition<PostfixTemplate> createIsApplicationTemplateFunction(@NotNull String key, @NotNull PsiFile file, @NotNull Editor editor) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "createIsApplicationTemplateFunction"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "createIsApplicationTemplateFunction"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "createIsApplicationTemplateFunction"));
        }
        int currentOffset = editor.getCaretModel().getOffset();
        final int newOffset = currentOffset - key.length();
        CharSequence fileContent = editor.getDocument().getCharsSequence();
        StringBuilder fileContentWithoutKey = new StringBuilder();
        fileContentWithoutKey.append(fileContent.subSequence(0, newOffset));
        fileContentWithoutKey.append(fileContent.subSequence(currentOffset, fileContent.length()));
        PsiFile copyFile = PostfixLiveTemplate.copyFile(file, fileContentWithoutKey);
        Document copyDocument = copyFile.getViewProvider().getDocument();
        if (copyDocument == null) {
            return Condition.FALSE;
        }
        if (PostfixLiveTemplate.isSemicolonNeeded(copyFile, editor)) {
            fileContentWithoutKey.insert(newOffset, ';');
            copyFile = PostfixLiveTemplate.copyFile(file, fileContentWithoutKey);
            copyDocument = copyFile.getViewProvider().getDocument();
            if (copyDocument == null) {
                return Condition.FALSE;
            }
        }
        final PsiElement context = CustomTemplateCallback.getContext(copyFile, newOffset > 0 ? newOffset - 1 : newOffset);
        final Document finalCopyDocument = copyDocument;
        return new Condition<PostfixTemplate>(){

            public boolean value(PostfixTemplate template) {
                return template != null && template.isEnabled() && template.isApplicable(context, finalCopyDocument, newOffset);
            }
        };
    }

    @NotNull
    private static PsiFile copyFile(@NotNull PsiFile file, @NotNull StringBuilder fileContentWithoutKey) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "copyFile"));
        }
        if (fileContentWithoutKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "copyFile"));
        }
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)file.getProject());
        PsiFile copy = psiFileFactory.createFileFromText(file.getName(), file.getFileType(), (CharSequence)fileContentWithoutKey);
        VirtualFile vFile = copy.getVirtualFile();
        if (vFile != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        PsiFile psiFile = copy;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "copyFile"));
        }
        return psiFile;
    }

    @NotNull
    private static PsiElement deleteTemplateKey(final @NotNull PsiFile file, final @NotNull Document document, final int currentOffset, @NotNull String key) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "deleteTemplateKey"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "deleteTemplateKey"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "deleteTemplateKey"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final int startOffset = currentOffset - key.length();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                    @Override
                    public void run() {
                        document.deleteString(startOffset, currentOffset);
                        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
                    }
                });
            }
        });
        PsiElement psiElement = CustomTemplateCallback.getContext(file, startOffset > 0 ? startOffset - 1 : startOffset);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "deleteTemplateKey"));
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement addSemicolonIfNeeded(@NotNull Editor editor, final @NotNull Document document, final @NotNull PsiElement context, final int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "addSemicolonIfNeeded"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "addSemicolonIfNeeded"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "addSemicolonIfNeeded"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final Ref newContext = Ref.create((Object)context);
        final PsiFile file = context.getContainingFile();
        if (PostfixLiveTemplate.isSemicolonNeeded(file, editor)) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                        @Override
                        public void run() {
                            document.insertString(offset, (CharSequence)";");
                            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
                            newContext.set((Object)CustomTemplateCallback.getContext(file, offset - 1));
                        }
                    });
                }
            });
        }
        PsiElement psiElement = (PsiElement)newContext.get();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "addSemicolonIfNeeded"));
        }
        return psiElement;
    }

    private static boolean isSemicolonNeeded(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "isSemicolonNeeded"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate", "isSemicolonNeeded"));
        }
        return JavaCompletionContributor.semicolonNeeded(editor, file, CompletionInitializationContext.calcStartOffset((Editor)editor));
    }
}

