/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.ExpressionPostfixTemplateWithChooser;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.annotations.NotNull;

public class ParenthesizedExpressionPostfixTemplate
extends ExpressionPostfixTemplateWithChooser {
    public ParenthesizedExpressionPostfixTemplate() {
        super("par", "Parenthesizes expression", "(expression)");
    }

    @Override
    protected void doIt(@NotNull Editor editor, @NotNull PsiExpression expression) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ParenthesizedExpressionPostfixTemplate", "doIt"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/ParenthesizedExpressionPostfixTemplate", "doIt"));
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory();
        PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)factory.createExpressionFromText("(expr)", expression.getParent());
        PsiExpression operand = parenthesizedExpression.getExpression();
        assert (operand != null);
        operand.replace((PsiElement)expression);
        expression.replace((PsiElement)parenthesizedExpression);
    }
}

