/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.PostfixTemplatesUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import org.jetbrains.annotations.NotNull;

public abstract class NullCheckPostfixTemplate
extends PostfixTemplate {
    protected NullCheckPostfixTemplate(@NotNull String name, @NotNull String description, @NotNull String example) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/NullCheckPostfixTemplate", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/NullCheckPostfixTemplate", "<init>"));
        }
        if (example == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/templates/NullCheckPostfixTemplate", "<init>"));
        }
        super(name, description, example);
    }

    @NotNull
    abstract String getTail();

    @Override
    public boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/NullCheckPostfixTemplate", "isApplicable"));
        }
        if (copyDocument == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/NullCheckPostfixTemplate", "isApplicable"));
        }
        return PostfixTemplatesUtils.isNotPrimitiveTypeExpression(NullCheckPostfixTemplate.getTopmostExpression(context));
    }

    @Override
    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/NullCheckPostfixTemplate", "expand"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/NullCheckPostfixTemplate", "expand"));
        }
        PsiExpression expr = NullCheckPostfixTemplate.getTopmostExpression(context);
        if (!PostfixTemplatesUtils.isNotPrimitiveTypeExpression(expr)) {
            return;
        }
        Project project = expr.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiExpression condition = factory.createExpressionFromText(expr.getText() + this.getTail(), context);
        PsiElement replace = expr.replace((PsiElement)condition);
        assert (replace instanceof PsiExpression);
        TextRange range = PostfixTemplatesUtils.ifStatement(project, editor, (PsiExpression)replace);
        if (range != null) {
            editor.getCaretModel().moveToOffset(range.getStartOffset());
        }
    }
}

