/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.SuggestVariableNameMacro;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.PostfixTemplatesUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ForIndexedPostfixTemplate
extends PostfixTemplate {
    protected ForIndexedPostfixTemplate(@NotNull String key, @NotNull String description, @NotNull String example) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ForIndexedPostfixTemplate", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/ForIndexedPostfixTemplate", "<init>"));
        }
        if (example == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/templates/ForIndexedPostfixTemplate", "<init>"));
        }
        super(key, description, example);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ForIndexedPostfixTemplate", "isApplicable"));
        }
        if (copyDocument == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/ForIndexedPostfixTemplate", "isApplicable"));
        }
        PsiExpression expr = ForIndexedPostfixTemplate.getTopmostExpression(context);
        return expr != null && (PostfixTemplatesUtils.isNumber(expr.getType()) || PostfixTemplatesUtils.isArray(expr.getType()) || PostfixTemplatesUtils.isIterable(expr.getType()));
    }

    @Override
    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ForIndexedPostfixTemplate", "expand"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/ForIndexedPostfixTemplate", "expand"));
        }
        PsiExpression expr = ForIndexedPostfixTemplate.getTopmostExpression(context);
        if (expr == null) {
            PostfixTemplatesUtils.showErrorHint(context.getProject(), editor);
            return;
        }
        Pair<String, String> bounds = this.calculateBounds(expr);
        if (bounds == null) {
            PostfixTemplatesUtils.showErrorHint(context.getProject(), editor);
            return;
        }
        Project project = context.getProject();
        Document document = editor.getDocument();
        document.deleteString(expr.getTextRange().getStartOffset(), expr.getTextRange().getEndOffset());
        TemplateManager manager = TemplateManager.getInstance(project);
        Template template = manager.createTemplate("", "");
        template.setToReformat(true);
        template.addTextSegment("for (" + ForIndexedPostfixTemplate.suggestIndexType(expr) + " ");
        MacroCallNode index = new MacroCallNode(new SuggestVariableNameMacro());
        String indexVariable = "index";
        template.addVariable(indexVariable, index, index, true);
        template.addTextSegment(" = " + (String)bounds.first + "; ");
        template.addVariableSegment(indexVariable);
        template.addTextSegment(this.getComparativeSign(expr));
        template.addTextSegment((String)bounds.second);
        template.addTextSegment("; ");
        template.addVariableSegment(indexVariable);
        template.addTextSegment(this.getOperator());
        template.addTextSegment(") {\n");
        template.addEndVariable();
        template.addTextSegment("\n}");
        manager.startTemplate(editor, template);
    }

    @NotNull
    protected abstract String getComparativeSign(@NotNull PsiExpression var1);

    @Nullable
    protected abstract Pair<String, String> calculateBounds(@NotNull PsiExpression var1);

    @NotNull
    protected abstract String getOperator();

    @Nullable
    protected static String getExpressionBound(@NotNull PsiExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ForIndexedPostfixTemplate", "getExpressionBound"));
        }
        PsiType type = expr.getType();
        if (PostfixTemplatesUtils.isNumber(type)) {
            return expr.getText();
        }
        if (PostfixTemplatesUtils.isArray(type)) {
            return expr.getText() + ".length";
        }
        if (PostfixTemplatesUtils.isIterable(type)) {
            return expr.getText() + ".size()";
        }
        return null;
    }

    @NotNull
    private static String suggestIndexType(@NotNull PsiExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ForIndexedPostfixTemplate", "suggestIndexType"));
        }
        PsiType type = expr.getType();
        if (PostfixTemplatesUtils.isNumber(type)) {
            String string = type.getCanonicalText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/ForIndexedPostfixTemplate", "suggestIndexType"));
            }
            return string;
        }
        if ("int" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/ForIndexedPostfixTemplate", "suggestIndexType"));
        }
        return "int";
    }
}

