/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.PostfixTemplatesUtils;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ExpressionPostfixTemplateWithChooser
extends PostfixTemplate {
    protected ExpressionPostfixTemplateWithChooser(@NotNull String name, @NotNull String description, @NotNull String example) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "<init>"));
        }
        if (example == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "<init>"));
        }
        super(name, description, example);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "isApplicable"));
        }
        if (copyDocument == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "isApplicable"));
        }
        return !this.getExpressions(context, copyDocument, newOffset).isEmpty();
    }

    @Override
    public void expand(@NotNull PsiElement context, final @NotNull Editor editor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "expand"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "expand"));
        }
        List<PsiExpression> expressions = this.getExpressions(context, editor.getDocument(), editor.getCaretModel().getOffset());
        if (expressions.isEmpty()) {
            PostfixTemplatesUtils.showErrorHint(context.getProject(), editor);
        } else if (expressions.size() == 1) {
            this.doIt(editor, expressions.get(0));
        } else {
            IntroduceTargetChooser.showChooser(editor, expressions, new Pass<PsiExpression>(){

                public void pass(final @NotNull PsiExpression e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser$1", "pass"));
                    }
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            CommandProcessor.getInstance().executeCommand(e.getProject(), new Runnable(){

                                @Override
                                public void run() {
                                    ExpressionPostfixTemplateWithChooser.this.doIt(editor, e);
                                }
                            }, "Expand postfix template", (Object)"POSTFIX_TEMPLATE_ID");
                        }
                    });
                }
            }, new PsiExpressionTrimRenderer.RenderFunction(), "Expressions", 0, ScopeHighlighter.NATURAL_RANGER);
        }
    }

    @NotNull
    protected List<PsiExpression> getExpressions(@NotNull PsiElement context, @NotNull Document document, final int offset) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "getExpressions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "getExpressions"));
        }
        List<PsiExpression> expressions = ContainerUtil.filter(IntroduceVariableBase.collectExpressions(context.getContainingFile(), document, Math.max(offset - 1, 0), false), (Condition)new Condition<PsiExpression>(){

            public boolean value(PsiExpression expression) {
                return expression.getTextRange().getEndOffset() == offset;
            }
        });
        List list = ContainerUtil.filter(expressions.isEmpty() ? ExpressionPostfixTemplateWithChooser.maybeTopmostExpression(context) : expressions, this.getTypeCondition());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "getExpressions"));
        }
        return list;
    }

    @NotNull
    protected Condition<PsiExpression> getTypeCondition() {
        Condition condition = Condition.TRUE;
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "getTypeCondition"));
        }
        return condition;
    }

    @NotNull
    private static List<PsiExpression> maybeTopmostExpression(@NotNull PsiElement context) {
        PsiType type;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "maybeTopmostExpression"));
        }
        PsiExpression expression = ExpressionPostfixTemplateWithChooser.getTopmostExpression(context);
        PsiType psiType = type = expression != null ? expression.getType() : null;
        if (type == null || PsiType.VOID.equals((Object)type)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "maybeTopmostExpression"));
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)expression);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/ExpressionPostfixTemplateWithChooser", "maybeTopmostExpression"));
        }
        return list;
    }

    protected abstract void doIt(@NotNull Editor var1, @NotNull PsiExpression var2);
}

