/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.CodeInsightServicesUtil;
import com.intellij.codeInsight.template.postfix.templates.BooleanPostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.PostfixTemplatesUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import org.jetbrains.annotations.NotNull;

public class ElseStatementPostfixTemplate
extends BooleanPostfixTemplate {
    public ElseStatementPostfixTemplate() {
        super("else", "Checks boolean expression to be 'false'", "if (!expr)");
    }

    @Override
    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ElseStatementPostfixTemplate", "expand"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/ElseStatementPostfixTemplate", "expand"));
        }
        PsiExpression expression = ElseStatementPostfixTemplate.getTopmostExpression(context);
        assert (expression != null);
        PsiExpression invertedExpression = (PsiExpression)expression.replace((PsiElement)CodeInsightServicesUtil.invertCondition((PsiExpression)expression));
        TextRange range = PostfixTemplatesUtils.ifStatement(invertedExpression.getProject(), editor, invertedExpression);
        if (range != null) {
            editor.getCaretModel().moveToOffset(range.getStartOffset());
        }
    }
}

