/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PostfixTemplatesSettings", storages={@Storage(file="$APP_CONFIG$/postfixTemplates.xml")})
public class PostfixTemplatesSettings
implements PersistentStateComponent<PostfixTemplatesSettings>,
ExportableComponent {
    @NotNull
    private Map<String, Boolean> myTemplatesState = ContainerUtil.newHashMap();
    private boolean postfixTemplatesEnabled = true;
    private boolean templatesCompletionEnabled = true;
    private int myShortcut = 9;

    public boolean isTemplateEnabled(@NotNull PostfixTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "isTemplateEnabled"));
        }
        return (Boolean)ContainerUtil.getOrElse(this.myTemplatesState, (Object)template.getKey(), (Object)true);
    }

    public void disableTemplate(@NotNull PostfixTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "disableTemplate"));
        }
        this.myTemplatesState.put(template.getKey(), Boolean.FALSE);
    }

    public boolean isPostfixTemplatesEnabled() {
        return this.postfixTemplatesEnabled;
    }

    public void setPostfixTemplatesEnabled(boolean postfixTemplatesEnabled) {
        this.postfixTemplatesEnabled = postfixTemplatesEnabled;
    }

    public boolean isTemplatesCompletionEnabled() {
        return this.templatesCompletionEnabled;
    }

    public void setTemplatesCompletionEnabled(boolean templatesCompletionEnabled) {
        this.templatesCompletionEnabled = templatesCompletionEnabled;
    }

    @NotNull
    public Map<String, Boolean> getTemplatesState() {
        Map<String, Boolean> map = this.myTemplatesState;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "getTemplatesState"));
        }
        return map;
    }

    public void setTemplatesState(@NotNull Map<String, Boolean> templatesState) {
        if (templatesState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "setTemplatesState"));
        }
        this.myTemplatesState = templatesState;
    }

    public int getShortcut() {
        return this.myShortcut;
    }

    public void setShortcut(int shortcut) {
        this.myShortcut = shortcut;
    }

    @Nullable
    public static PostfixTemplatesSettings getInstance() {
        return (PostfixTemplatesSettings)ServiceManager.getService(PostfixTemplatesSettings.class);
    }

    @Nullable
    public PostfixTemplatesSettings getState() {
        return this;
    }

    public void loadState(PostfixTemplatesSettings settings) {
        XmlSerializerUtil.copyBean((Object)settings, (Object)this);
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)"postfixCompletion.xml")};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        if ("Postfix Completion" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "getPresentableName"));
        }
        return "Postfix Completion";
    }
}

