/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.TableView;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixTemplatesListPanel {
    private static final NotNullFunction<PostfixTemplate, String> GET_SHORTCUT_FUNCTION = new NotNullFunction<PostfixTemplate, String>(){

        @NotNull
        public String fun(@NotNull PostfixTemplate template) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel$1", "fun"));
            }
            String string = template.getKey().replaceFirst(".", "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel$1", "fun"));
            }
            return string;
        }
    };
    private static final NotNullFunction<PostfixTemplate, String> GET_DESCRIPTION_FUNCTION = new NotNullFunction<PostfixTemplate, String>(){

        @NotNull
        public String fun(@NotNull PostfixTemplate template) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel$2", "fun"));
            }
            String string = template.getDescription();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel$2", "fun"));
            }
            return string;
        }
    };
    private static final NotNullFunction<PostfixTemplate, String> GET_EXAMPLE_FUNCTION = new NotNullFunction<PostfixTemplate, String>(){

        @NotNull
        public String fun(@NotNull PostfixTemplate template) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel$3", "fun"));
            }
            String string = template.getExample();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel$3", "fun"));
            }
            return string;
        }
    };
    @NotNull
    private final Map<String, Boolean> myTemplatesState;
    @NotNull
    private final JPanel myPanelWithTableView;
    private final TableView<PostfixTemplate> myTemplatesTableView;

    public PostfixTemplatesListPanel(@NotNull List<PostfixTemplate> templates) {
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel", "<init>"));
        }
        this.myTemplatesState = ContainerUtil.newHashMap();
        ColumnInfo[] columns = this.generateColumns(templates);
        ListTableModel templatesTableModel = new ListTableModel(columns, templates, 0);
        templatesTableModel.setSortable(true);
        this.myTemplatesTableView = new TableView();
        this.myTemplatesTableView.setModelAndUpdateColumns(templatesTableModel);
        this.myTemplatesTableView.setAutoCreateRowSorter(true);
        this.myTemplatesTableView.setShowGrid(false);
        this.myTemplatesTableView.setBorder(null);
        new TableViewSpeedSearch<PostfixTemplate>(this.myTemplatesTableView){

            @Override
            protected String getItemText(@NotNull PostfixTemplate template) {
                if (template == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel$4", "getItemText"));
                }
                return template.getPresentableName();
            }
        };
        this.myPanelWithTableView = ToolbarDecorator.createDecorator(this.myTemplatesTableView).setAsUsualTopToolbar().disableAddAction().disableRemoveAction().disableUpDownActions().createPanel();
    }

    @NotNull
    private ColumnInfo[] generateColumns(@NotNull List<PostfixTemplate> templates) {
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel", "generateColumns"));
        }
        String longestTemplateName = "";
        String longestDescription = "";
        String longestExample = "";
        for (PostfixTemplate template : templates) {
            longestTemplateName = PostfixTemplatesListPanel.longestString(longestTemplateName, (String)GET_SHORTCUT_FUNCTION.fun((Object)template));
            longestDescription = PostfixTemplatesListPanel.longestString(longestDescription, (String)GET_DESCRIPTION_FUNCTION.fun((Object)template));
            longestExample = PostfixTemplatesListPanel.longestString(longestExample, (String)GET_EXAMPLE_FUNCTION.fun((Object)template));
        }
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new BooleanColumnInfo(), new StringColumnInfo("Shortcut", (Function<PostfixTemplate, String>)GET_SHORTCUT_FUNCTION, longestTemplateName), new StringColumnInfo("Description", (Function<PostfixTemplate, String>)GET_DESCRIPTION_FUNCTION, longestDescription), new StringColumnInfo("Example", (Function<PostfixTemplate, String>)GET_EXAMPLE_FUNCTION, longestExample)};
        if (columnInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel", "generateColumns"));
        }
        return columnInfoArray;
    }

    public void selectTemplate(@NotNull PostfixTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel", "selectTemplate"));
        }
        this.myTemplatesTableView.setSelection(Arrays.asList(template));
    }

    @NotNull
    private static String longestString(@NotNull String firstString, @NotNull String secondString) {
        if (firstString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel", "longestString"));
        }
        if (secondString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel", "longestString"));
        }
        String string = secondString.length() > firstString.length() ? secondString : firstString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel", "longestString"));
        }
        return string;
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myPanelWithTableView;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel", "getComponent"));
        }
        return jPanel;
    }

    public void setState(@NotNull Map<String, Boolean> templatesState) {
        if (templatesState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel", "setState"));
        }
        this.myTemplatesState.clear();
        for (Map.Entry<String, Boolean> entry : templatesState.entrySet()) {
            this.myTemplatesState.put(entry.getKey(), entry.getValue());
        }
    }

    @NotNull
    public Map<String, Boolean> getState() {
        Map<String, Boolean> map = this.myTemplatesState;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel", "getState"));
        }
        return map;
    }

    public void setEnabled(boolean enabled) {
        this.myTemplatesTableView.setEnabled(enabled);
    }

    private static class StringColumnInfo
    extends ColumnInfo<PostfixTemplate, String> {
        @NotNull
        private final Function<PostfixTemplate, String> myValueOfFunction;
        @Nullable
        private final String myPreferredStringValue;

        public StringColumnInfo(@NotNull String name, @NotNull Function<PostfixTemplate, String> valueOfFunction, @Nullable String preferredStringValue) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel$StringColumnInfo", "<init>"));
            }
            if (valueOfFunction == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel$StringColumnInfo", "<init>"));
            }
            super(name);
            this.myValueOfFunction = valueOfFunction;
            boolean hasValue = preferredStringValue != null && !preferredStringValue.isEmpty();
            this.myPreferredStringValue = hasValue ? preferredStringValue : null;
        }

        public int getAdditionalWidth() {
            return 10;
        }

        @Nullable
        public String getPreferredStringValue() {
            return this.myPreferredStringValue;
        }

        public String valueOf(PostfixTemplate template) {
            return (String)this.myValueOfFunction.fun((Object)template);
        }
    }

    private class BooleanColumnInfo
    extends ColumnInfo<PostfixTemplate, Boolean> {
        private final BooleanTableCellRenderer CELL_RENDERER;
        private final BooleanTableCellEditor CELL_EDITOR;
        private final int WIDTH;

        public BooleanColumnInfo() {
            super("");
            this.CELL_RENDERER = new BooleanTableCellRenderer();
            this.CELL_EDITOR = new BooleanTableCellEditor();
            this.WIDTH = new JBCheckBox().getPreferredSize().width + 4;
        }

        @Nullable
        public TableCellRenderer getRenderer(PostfixTemplate template) {
            return this.CELL_RENDERER;
        }

        @Nullable
        public TableCellEditor getEditor(PostfixTemplate template) {
            return this.CELL_EDITOR;
        }

        public int getWidth(JTable table) {
            return this.WIDTH;
        }

        @NotNull
        public Class getColumnClass() {
            if (Boolean.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel$BooleanColumnInfo", "getColumnClass"));
            }
            return Boolean.class;
        }

        public boolean isCellEditable(PostfixTemplate template) {
            return PostfixTemplatesListPanel.this.myTemplatesTableView.isEnabled();
        }

        @Nullable
        public Boolean valueOf(@NotNull PostfixTemplate template) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel$BooleanColumnInfo", "valueOf"));
            }
            return (Boolean)ContainerUtil.getOrElse((Map)PostfixTemplatesListPanel.this.myTemplatesState, (Object)template.getKey(), (Object)true);
        }

        public void setValue(@NotNull PostfixTemplate template, Boolean value) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesListPanel$BooleanColumnInfo", "setValue"));
            }
            PostfixTemplatesListPanel.this.myTemplatesState.put(template.getKey(), value);
        }
    }
}

