/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesListPanel;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixTemplatesConfigurable
implements SearchableConfigurable,
EditorOptionsProvider,
Configurable.NoScroll {
    @Nullable
    private PostfixTemplatesListPanel myTemplatesListPanel;
    @NotNull
    private final PostfixTemplatesSettings myTemplatesSettings;
    private JComponent myPanel;
    private JBCheckBox myCompletionEnabledCheckbox;
    private JBCheckBox myPostfixTemplatesEnabled;
    private JPanel myTemplatesListPanelContainer;
    private ComboBox myShortcutComboBox;
    private static final String SPACE = CodeInsightBundle.message((String)"template.shortcut.space", (Object[])new Object[0]);
    private static final String TAB = CodeInsightBundle.message((String)"template.shortcut.tab", (Object[])new Object[0]);
    private static final String ENTER = CodeInsightBundle.message((String)"template.shortcut.enter", (Object[])new Object[0]);

    public PostfixTemplatesConfigurable() {
        this.$$$setupUI$$$();
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        if (settings == null) {
            throw new RuntimeException("Can't retrieve postfix template settings");
        }
        this.myTemplatesSettings = settings;
        List<Object> templates = Arrays.asList(PostfixTemplate.EP_NAME.getExtensions());
        ContainerUtil.sort(templates, (Comparator)new Comparator<PostfixTemplate>(){

            @Override
            public int compare(PostfixTemplate o1, PostfixTemplate o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        this.myTemplatesListPanel = new PostfixTemplatesListPanel(templates);
        this.myTemplatesListPanelContainer.setLayout(new BorderLayout());
        this.myTemplatesListPanelContainer.add((Component)this.myTemplatesListPanel.getComponent(), "Center");
        this.myPostfixTemplatesEnabled.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PostfixTemplatesConfigurable.this.updateComponents();
            }
        });
        this.myShortcutComboBox.addItem((Object)TAB);
        this.myShortcutComboBox.addItem((Object)SPACE);
        this.myShortcutComboBox.addItem((Object)ENTER);
    }

    @NotNull
    public String getId() {
        if ("reference.settingsdialog.IDE.editor.postfix.templates" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesConfigurable", "getId"));
        }
        return "reference.settingsdialog.IDE.editor.postfix.templates";
    }

    @Nullable
    public String getHelpTopic() {
        return this.getId();
    }

    @Nls
    public String getDisplayName() {
        return "Postfix Completion";
    }

    @Nullable
    public PostfixTemplatesListPanel getTemplatesListPanel() {
        return this.myTemplatesListPanel;
    }

    @NotNull
    public JComponent createComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesConfigurable", "createComponent"));
        }
        return jComponent;
    }

    public void apply() throws ConfigurationException {
        if (this.myTemplatesListPanel != null) {
            HashMap newTemplatesState = ContainerUtil.newHashMap();
            for (Map.Entry<String, Boolean> entry : this.myTemplatesListPanel.getState().entrySet()) {
                Boolean value = entry.getValue();
                if (value == null || value.booleanValue()) continue;
                newTemplatesState.put(entry.getKey(), entry.getValue());
            }
            this.myTemplatesSettings.setTemplatesState(newTemplatesState);
            this.myTemplatesSettings.setPostfixTemplatesEnabled(this.myPostfixTemplatesEnabled.isSelected());
            this.myTemplatesSettings.setTemplatesCompletionEnabled(this.myCompletionEnabledCheckbox.isSelected());
            this.myTemplatesSettings.setShortcut(PostfixTemplatesConfigurable.stringToShortcut((String)this.myShortcutComboBox.getSelectedItem()));
        }
    }

    public void reset() {
        if (this.myTemplatesListPanel != null) {
            this.myTemplatesListPanel.setState(this.myTemplatesSettings.getTemplatesState());
            this.myPostfixTemplatesEnabled.setSelected(this.myTemplatesSettings.isPostfixTemplatesEnabled());
            this.myCompletionEnabledCheckbox.setSelected(this.myTemplatesSettings.isTemplatesCompletionEnabled());
            this.myShortcutComboBox.setSelectedItem((Object)PostfixTemplatesConfigurable.shortcutToString((char)this.myTemplatesSettings.getShortcut()));
            this.updateComponents();
        }
    }

    public boolean isModified() {
        if (this.myTemplatesListPanel == null) {
            return false;
        }
        return this.myPostfixTemplatesEnabled.isSelected() != this.myTemplatesSettings.isPostfixTemplatesEnabled() || this.myCompletionEnabledCheckbox.isSelected() != this.myTemplatesSettings.isTemplatesCompletionEnabled() || PostfixTemplatesConfigurable.stringToShortcut((String)this.myShortcutComboBox.getSelectedItem()) != this.myTemplatesSettings.getShortcut() || !((Object)this.myTemplatesListPanel.getState()).equals(this.myTemplatesSettings.getTemplatesState());
    }

    public void disposeUIResources() {
        this.myTemplatesListPanel = null;
    }

    @Nullable
    public Runnable enableSearch(String s) {
        return null;
    }

    private void updateComponents() {
        boolean pluginEnabled = this.myPostfixTemplatesEnabled.isSelected();
        this.myCompletionEnabledCheckbox.setVisible(!LiveTemplateCompletionContributor.shouldShowAllTemplates());
        this.myCompletionEnabledCheckbox.setEnabled(pluginEnabled);
        this.myShortcutComboBox.setEnabled(pluginEnabled);
        if (this.myTemplatesListPanel != null) {
            this.myTemplatesListPanel.setEnabled(pluginEnabled);
        }
    }

    private static char stringToShortcut(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesConfigurable", "stringToShortcut"));
        }
        if (SPACE.equals(string)) {
            return ' ';
        }
        if (ENTER.equals(string)) {
            return '\n';
        }
        return '\t';
    }

    private static String shortcutToString(char shortcut) {
        if (shortcut == ' ') {
            return SPACE;
        }
        if (shortcut == '\n') {
            return ENTER;
        }
        return TAB;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JPanel jPanel2 = new JPanel();
        this.myPanel = jPanel2;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPostfixTemplatesEnabled = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Enable postfix templates");
        jBCheckBox2.setMnemonic('E');
        jBCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 2, 1, 1, 3, 1, null, null, null));
        this.myTemplatesListPanelContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCompletionEnabledCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show postfix templates in completion autopopup");
        jBCheckBox.setMnemonic('S');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Expand templates with");
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 1, null, null, null, 1));
        this.myShortcutComboBox = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

