/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.completion;

import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.templates.PostfixLiveTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.NotNull;

public class PostfixTemplateLookupElement
extends CustomLiveTemplateLookupElement {
    @NotNull
    private final PostfixTemplate myTemplate;

    public PostfixTemplateLookupElement(@NotNull PostfixLiveTemplate liveTemplate, @NotNull PostfixTemplate postfixTemplate, @NotNull String templateKey, boolean sudden) {
        if (liveTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplateLookupElement", "<init>"));
        }
        if (postfixTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplateLookupElement", "<init>"));
        }
        if (templateKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplateLookupElement", "<init>"));
        }
        super(liveTemplate, templateKey, postfixTemplate.getPresentableName(), postfixTemplate.getDescription(), sudden, true);
        this.myTemplate = postfixTemplate;
    }

    @NotNull
    public PostfixTemplate getPostfixTemplate() {
        PostfixTemplate postfixTemplate = this.myTemplate;
        if (postfixTemplate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplateLookupElement", "getPostfixTemplate"));
        }
        return postfixTemplate;
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        if (this.sudden) {
            presentation.setTailText(" " + PostfixTemplateLookupElement.arrow() + " " + this.myTemplate.getExample());
        } else {
            presentation.setTypeText(this.myTemplate.getExample());
            presentation.setTypeGrayed(true);
        }
    }

    private static String arrow() {
        return SystemInfo.isMac ? "\u2192" : "->";
    }
}

