/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CastToLeftSideTypeMacro
extends Macro {
    public String getName() {
        return "castToLeftSideType";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.cast.to.left.side.type", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        if ("(A)" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/CastToLeftSideTypeMacro", "getDefaultValue"));
        }
        return "(A)";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/macro/CastToLeftSideTypeMacro", "calculateResult"));
        }
        int offset = context.getStartOffset();
        Project project = context.getProject();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiElement element = file.findElementAt(offset);
        element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiAssignmentExpression.class, PsiVariable.class});
        PsiType leftType = null;
        PsiExpression rightSide = null;
        if (element instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
            leftType = assignment.getLExpression().getType();
            rightSide = assignment.getRExpression();
        } else if (element instanceof PsiVariable) {
            PsiVariable var = (PsiVariable)element;
            leftType = var.getType();
            rightSide = var.getInitializer();
        }
        while (rightSide instanceof PsiTypeCastExpression) {
            rightSide = ((PsiTypeCastExpression)rightSide).getOperand();
        }
        if (leftType != null && rightSide != null && rightSide.getType() != null && !leftType.isAssignableFrom(rightSide.getType())) {
            return new TextResult("(" + leftType.getCanonicalText() + ")");
        }
        return new TextResult("");
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

