/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl.editorActions;

import com.intellij.codeInsight.editorActions.BaseEnterHandler;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;

public class EnterHandler
extends BaseEnterHandler {
    private final EditorActionHandler myOriginalHandler;

    public EnterHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        return this.myOriginalHandler.isEnabled(editor, dataContext);
    }

    public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            TemplateManagerImpl templateManager = (TemplateManagerImpl)TemplateManager.getInstance(project);
            if (templateManager != null && templateManager.startTemplate(editor, '\n')) {
                return;
            }
        }
        this.myOriginalHandler.execute(editor, caret, dataContext);
    }
}

