/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.RealLookupElementPresentation;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LiveTemplateLookupElement
extends LookupElement {
    private final String myLookupString;
    public final boolean sudden;
    private final boolean myWorthShowingInAutoPopup;
    private final String myDescription;

    public LiveTemplateLookupElement(@NotNull String lookupString, @Nullable String description, boolean sudden, boolean worthShowingInAutoPopup) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/impl/LiveTemplateLookupElement", "<init>"));
        }
        this.myDescription = description;
        this.sudden = sudden;
        this.myLookupString = lookupString;
        this.myWorthShowingInAutoPopup = worthShowingInAutoPopup;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myLookupString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/LiveTemplateLookupElement", "getLookupString"));
        }
        return string;
    }

    @NotNull
    protected String getItemText() {
        String string = this.myLookupString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/LiveTemplateLookupElement", "getItemText"));
        }
        return string;
    }

    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        char shortcut = this.getTemplateShortcut();
        presentation.setItemText(this.getItemText());
        if (this.sudden) {
            presentation.setItemTextBold(true);
            if (!presentation.isReal() || !((RealLookupElementPresentation)presentation).isLookupSelectionTouched()) {
                if (shortcut == 'D') {
                    shortcut = TemplateSettings.getInstance().getDefaultShortcutChar();
                }
                presentation.setTypeText("  [" + KeyEvent.getKeyText(shortcut) + "] ");
            }
            if (StringUtil.isNotEmpty((String)this.myDescription)) {
                presentation.setTailText(" (" + this.myDescription + ")", true);
            }
        } else {
            presentation.setTypeText(this.myDescription);
        }
    }

    public boolean isWorthShowingInAutoPopup() {
        return this.myWorthShowingInAutoPopup;
    }

    public abstract char getTemplateShortcut();
}

