/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPreselectSkipper;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.ListTemplatesHandler;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveTemplateCompletionContributor
extends CompletionContributor {
    public static boolean ourShowTemplatesInTests = false;

    public static boolean shouldShowAllTemplates() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return ourShowTemplatesInTests;
        }
        return Registry.is((String)"show.live.templates.in.completion");
    }

    public LiveTemplateCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor$1", "addCompletions"));
                }
                PsiFile file = parameters.getPosition().getContainingFile();
                if (file instanceof PsiPlainTextFile && parameters.getEditor().getComponent().getParent() instanceof EditorTextField) {
                    return;
                }
                int offset = parameters.getOffset();
                final List templates = LiveTemplateCompletionContributor.listApplicableTemplates(file, offset);
                Editor editor = parameters.getEditor();
                if (LiveTemplateCompletionContributor.this.showAllTemplates()) {
                    final MultiMap<String, CustomLiveTemplateLookupElement> customTemplates = ListTemplatesHandler.listApplicableCustomTemplates(editor, file, offset);
                    final Ref templatesShown = Ref.create((Object)false);
                    final CompletionResultSet finalResult = result;
                    result.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>(){

                        public void consume(CompletionResult completionResult) {
                            finalResult.passResult(completionResult);
                            LiveTemplateCompletionContributor.ensureTemplatesShown((Ref<Boolean>)templatesShown, templates, (MultiMap<String, CustomLiveTemplateLookupElement>)customTemplates, finalResult);
                        }
                    });
                    LiveTemplateCompletionContributor.ensureTemplatesShown((Ref<Boolean>)templatesShown, templates, (MultiMap<String, CustomLiveTemplateLookupElement>)customTemplates, result);
                    return;
                }
                if (parameters.getInvocationCount() > 0) {
                    return;
                }
                String templatePrefix = LiveTemplateCompletionContributor.findLiveTemplatePrefix(file, editor, result.getPrefixMatcher().getPrefix());
                TemplateImpl template = LiveTemplateCompletionContributor.findApplicableTemplate(file, offset, templatePrefix);
                if (template != null) {
                    result = result.withPrefixMatcher(template.getKey());
                    result.addElement((LookupElement)new LiveTemplateLookupElementImpl(template, true));
                }
                for (TemplateImpl possible : templates) {
                    result.restartCompletionOnPrefixChange(possible.getKey());
                }
            }
        });
    }

    protected boolean showAllTemplates() {
        return LiveTemplateCompletionContributor.shouldShowAllTemplates();
    }

    private static void ensureTemplatesShown(Ref<Boolean> templatesShown, List<TemplateImpl> templates, MultiMap<String, CustomLiveTemplateLookupElement> customTemplates, CompletionResultSet result) {
        if (!((Boolean)templatesShown.get()).booleanValue()) {
            templatesShown.set((Object)true);
            for (TemplateImpl possible : templates) {
                result.addElement((LookupElement)new LiveTemplateLookupElementImpl(possible, false));
            }
            for (Map.Entry entry : customTemplates.entrySet()) {
                Collection value = (Collection)entry.getValue();
                if (value.isEmpty()) continue;
                result.withPrefixMatcher((String)entry.getKey()).addAllElements((Iterable)value);
            }
        }
    }

    private static List<TemplateImpl> listApplicableTemplates(PsiFile file, int offset) {
        Set<TemplateContextType> contextTypes = TemplateManagerImpl.getApplicableContextTypes(file, offset);
        ArrayList result = ContainerUtil.newArrayList();
        for (TemplateImpl template : TemplateSettings.getInstance().getTemplates()) {
            if (template.isDeactivated() || !TemplateManagerImpl.isApplicable(template, contextTypes)) continue;
            result.add(template);
        }
        return result;
    }

    @Nullable
    public static TemplateImpl findApplicableTemplate(PsiFile file, int offset, final @NotNull String possiblePrefix) {
        if (possiblePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor", "findApplicableTemplate"));
        }
        return (TemplateImpl)ContainerUtil.find(LiveTemplateCompletionContributor.listApplicableTemplates(file, offset), (Condition)new Condition<TemplateImpl>(){

            public boolean value(TemplateImpl template) {
                return possiblePrefix.equals(template.getKey());
            }
        });
    }

    @NotNull
    public static String findLiveTemplatePrefix(@NotNull PsiFile file, @NotNull Editor editor, @NotNull String defaultValue) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor", "findLiveTemplatePrefix"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor", "findLiveTemplatePrefix"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor", "findLiveTemplatePrefix"));
        }
        CustomTemplateCallback callback = new CustomTemplateCallback(editor, file, false);
        for (CustomLiveTemplate customLiveTemplate : (CustomLiveTemplate[])CustomLiveTemplate.EP_NAME.getExtensions()) {
            String customKey = customLiveTemplate.computeTemplateKey(callback);
            if (customKey == null) continue;
            String string = customKey;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor", "findLiveTemplatePrefix"));
            }
            return string;
        }
        String string = defaultValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor", "findLiveTemplatePrefix"));
        }
        return string;
    }

    public static class Skipper
    extends CompletionPreselectSkipper {
        public boolean skipElement(LookupElement element, CompletionLocation location) {
            return element instanceof LiveTemplateLookupElement && ((LiveTemplateLookupElement)element).sudden && !Registry.is((String)"ide.completion.autopopup.select.live.templates");
        }
    }
}

