/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.SurroundWithTemplateHandler;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateListPanel;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListTemplatesHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "invoke"));
        }
        if (!CodeInsightUtilBase.prepareEditorForWrite(editor)) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        EditorUtil.fillVirtualSpaceUntilCaret(editor);
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        int offset = editor.getCaretModel().getOffset();
        String prefix = ListTemplatesHandler.getPrefix(editor.getDocument(), offset, false);
        String prefixWithoutDots = ListTemplatesHandler.getPrefix(editor.getDocument(), offset, true);
        ArrayList<TemplateImpl> matchingTemplates = new ArrayList<TemplateImpl>();
        ArrayList<TemplateImpl> applicableTemplates = SurroundWithTemplateHandler.getApplicableTemplates(editor, file, false);
        Pattern prefixSearchPattern = Pattern.compile(".*\\b" + prefixWithoutDots + ".*");
        for (TemplateImpl template : applicableTemplates) {
            String templateDescription = template.getDescription();
            if (!template.getKey().startsWith(prefix) && (prefixWithoutDots.isEmpty() || templateDescription == null || !prefixSearchPattern.matcher(templateDescription).matches())) continue;
            matchingTemplates.add(template);
        }
        MultiMap<String, CustomLiveTemplateLookupElement> customTemplatesLookupElements = ListTemplatesHandler.listApplicableCustomTemplates(editor, file, offset);
        if (matchingTemplates.isEmpty()) {
            matchingTemplates.addAll(applicableTemplates);
            prefixWithoutDots = "";
        }
        if (matchingTemplates.isEmpty() && customTemplatesLookupElements.isEmpty()) {
            String text = prefixWithoutDots.length() == 0 ? CodeInsightBundle.message((String)"templates.no.defined", (Object[])new Object[0]) : CodeInsightBundle.message((String)"templates.no.defined.with.prefix", (Object[])new Object[]{prefix});
            HintManager.getInstance().showErrorHint(editor, text);
            return;
        }
        Collections.sort(matchingTemplates, TemplateListPanel.TEMPLATE_COMPARATOR);
        ListTemplatesHandler.showTemplatesLookup(project, editor, file, prefixWithoutDots, matchingTemplates, customTemplatesLookupElements);
    }

    private static void showTemplatesLookup(Project project, Editor editor, PsiFile file, @NotNull String prefix, @NotNull List<TemplateImpl> matchingTemplates, @NotNull MultiMap<String, CustomLiveTemplateLookupElement> customTemplatesLookupElements) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "showTemplatesLookup"));
        }
        if (matchingTemplates == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "showTemplatesLookup"));
        }
        if (customTemplatesLookupElements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "showTemplatesLookup"));
        }
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance(project).createLookup(editor, LookupElement.EMPTY_ARRAY, prefix, new TemplatesArranger());
        for (TemplateImpl template : matchingTemplates) {
            lookup.addItem(ListTemplatesHandler.createTemplateElement(template), (PrefixMatcher)new PlainPrefixMatcher(prefix));
        }
        for (Map.Entry entry : customTemplatesLookupElements.entrySet()) {
            for (CustomLiveTemplateLookupElement lookupElement : (Collection)entry.getValue()) {
                lookup.addItem(lookupElement, (PrefixMatcher)new PlainPrefixMatcher((String)entry.getKey()));
            }
        }
        ListTemplatesHandler.showLookup(lookup, file);
    }

    public static MultiMap<String, CustomLiveTemplateLookupElement> listApplicableCustomTemplates(@NotNull Editor editor, @NotNull PsiFile file, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "listApplicableCustomTemplates"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "listApplicableCustomTemplates"));
        }
        MultiMap result = MultiMap.create();
        CustomTemplateCallback customTemplateCallback = new CustomTemplateCallback(editor, file, false);
        for (CustomLiveTemplate customLiveTemplate : (CustomLiveTemplate[])CustomLiveTemplate.EP_NAME.getExtensions()) {
            String customTemplatePrefix;
            if (!(customLiveTemplate instanceof CustomLiveTemplateBase) || !TemplateManagerImpl.isApplicable(customLiveTemplate, editor, file) || (customTemplatePrefix = ((CustomLiveTemplateBase)customLiveTemplate).computeTemplateKeyWithoutContextChecking(customTemplateCallback)) == null) continue;
            result.putValues((Object)customTemplatePrefix, ((CustomLiveTemplateBase)customLiveTemplate).getLookupElements(file, editor, offset));
        }
        return result;
    }

    private static LiveTemplateLookupElement createTemplateElement(final TemplateImpl template) {
        return new LiveTemplateLookupElementImpl(template, false){

            public Set<String> getAllLookupStrings() {
                String description = template.getDescription();
                if (description == null) {
                    return super.getAllLookupStrings();
                }
                return ContainerUtil.newHashSet((Object[])new String[]{this.getLookupString(), description});
            }
        };
    }

    private static String computePrefix(TemplateImpl template, String argument) {
        String key = template.getKey();
        if (argument == null) {
            return key;
        }
        if (key.length() > 0 && Character.isJavaIdentifierPart(key.charAt(key.length() - 1))) {
            return key + ' ' + argument;
        }
        return key + argument;
    }

    public static void showTemplatesLookup(Project project, Editor editor, Map<TemplateImpl, String> template2Argument) {
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance(project).createLookup(editor, LookupElement.EMPTY_ARRAY, "", new LookupArranger.DefaultArranger());
        for (TemplateImpl template : template2Argument.keySet()) {
            String prefix = ListTemplatesHandler.computePrefix(template, template2Argument.get(template));
            lookup.addItem(ListTemplatesHandler.createTemplateElement(template), (PrefixMatcher)new PlainPrefixMatcher(prefix));
        }
        ListTemplatesHandler.showLookup(lookup, template2Argument);
    }

    private static void showLookup(LookupImpl lookup, @Nullable Map<TemplateImpl, String> template2Argument) {
        Editor editor = lookup.getEditor();
        Project project = editor.getProject();
        lookup.addLookupListener(new MyLookupAdapter(project, editor, template2Argument));
        lookup.refreshUi(false, true);
        lookup.showLookup();
    }

    private static void showLookup(LookupImpl lookup, @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "showLookup"));
        }
        Editor editor = lookup.getEditor();
        Project project = editor.getProject();
        lookup.addLookupListener(new MyLookupAdapter(project, editor, file));
        lookup.refreshUi(false, true);
        lookup.showLookup();
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static String getPrefix(Document document, int offset, boolean lettersOnly) {
        char c;
        int start;
        CharSequence chars = document.getCharsSequence();
        for (start = offset; start != 0 && (Character.isJavaIdentifierPart(c = chars.charAt(start - 1)) || !lettersOnly && c == '.'); --start) {
        }
        return ((Object)chars.subSequence(start, offset)).toString();
    }

    private static class TemplatesArranger
    extends LookupArranger {
        private TemplatesArranger() {
        }

        @Override
        public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup, boolean onExplicitAction) {
            if (lookup == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/impl/ListTemplatesHandler$TemplatesArranger", "arrangeItems"));
            }
            LinkedHashSet<LookupElement> result = new LinkedHashSet<LookupElement>();
            List<LookupElement> items = this.getMatchingItems();
            for (LookupElement item : items) {
                if (!item.getLookupString().startsWith(lookup.itemPattern(item))) continue;
                result.add(item);
            }
            result.addAll(items);
            ArrayList list = new ArrayList(result);
            int selected = lookup.isSelectionTouched() ? list.indexOf(lookup.getCurrentItem()) : 0;
            return new Pair(list, (Object)(selected >= 0 ? selected : 0));
        }

        @Override
        public LookupArranger createEmptyCopy() {
            return new TemplatesArranger();
        }
    }

    private static class MyLookupAdapter
    extends LookupAdapter {
        private final Project myProject;
        private final Editor myEditor;
        private final Map<TemplateImpl, String> myTemplate2Argument;
        private final PsiFile myFile;

        public MyLookupAdapter(Project project, Editor editor, @Nullable Map<TemplateImpl, String> template2Argument) {
            this.myProject = project;
            this.myEditor = editor;
            this.myTemplate2Argument = template2Argument;
            this.myFile = null;
        }

        public MyLookupAdapter(Project project, Editor editor, @Nullable PsiFile file) {
            this.myProject = project;
            this.myEditor = editor;
            this.myTemplate2Argument = null;
            this.myFile = file;
        }

        @Override
        public void itemSelected(LookupEvent event) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.liveTemplates");
            final LookupElement item = event.getItem();
            if (item instanceof LiveTemplateLookupElementImpl) {
                final TemplateImpl template = ((LiveTemplateLookupElementImpl)item).getTemplate();
                final String argument = this.myTemplate2Argument != null ? this.myTemplate2Argument.get(template) : null;
                new WriteCommandAction(this.myProject, new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/impl/ListTemplatesHandler$MyLookupAdapter$1", "run"));
                        }
                        ((TemplateManagerImpl)TemplateManager.getInstance(MyLookupAdapter.this.myProject)).startTemplateWithPrefix(MyLookupAdapter.this.myEditor, template, null, argument);
                    }
                }.execute();
            } else if (item instanceof CustomLiveTemplateLookupElement && this.myFile != null) {
                new WriteCommandAction(this.myProject, new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/impl/ListTemplatesHandler$MyLookupAdapter$2", "run"));
                        }
                        ((CustomLiveTemplateLookupElement)item).expandTemplate(MyLookupAdapter.this.myEditor, MyLookupAdapter.this.myFile);
                    }
                }.execute();
            }
        }
    }
}

