/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.google.common.base.Joiner;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateNode
extends ZenCodingNode {
    private static final Joiner JOINER = Joiner.on((String)",");
    private final TemplateToken myTemplateToken;
    @Nullable
    private final ZenCodingGenerator myGenerator;

    public TemplateNode(TemplateToken templateToken) {
        this(templateToken, null);
    }

    public TemplateNode(TemplateToken token, @Nullable ZenCodingGenerator generator) {
        this.myTemplateToken = token;
        this.myGenerator = generator;
    }

    public TemplateToken getTemplateToken() {
        return this.myTemplateToken;
    }

    @Override
    @NotNull
    public List<GenerationNode> expand(int numberInIteration, int totalIterations, String surroundedText, CustomTemplateCallback callback, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        TemplateToken templateToken = this.myTemplateToken;
        String templateKey = templateToken.getKey();
        if (this.myGenerator != null && StringUtil.containsChar((String)templateKey, (char)'$') && callback.findApplicableTemplate(templateKey) == null) {
            String newTemplateKey = ZenCodingUtil.replaceMarkers(templateKey, numberInIteration, totalIterations, surroundedText);
            TemplateToken newTemplateToken = new TemplateToken(newTemplateKey, templateToken.getAttribute2Value());
            TemplateImpl template = this.myGenerator.createTemplateByKey(newTemplateKey);
            if (template != null) {
                template.setDeactivated(true);
                newTemplateToken.setTemplate(template, callback);
                templateToken = newTemplateToken;
            }
        }
        GenerationNode node = new GenerationNode(templateToken, numberInIteration, totalIterations, surroundedText, insertSurroundedTextAtTheEnd, parent);
        List<GenerationNode> list = Arrays.asList(node);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/TemplateNode", "expand"));
        }
        return list;
    }

    public String toString() {
        String result = this.myTemplateToken.getKey();
        List<Pair<String, String>> attributes = this.myTemplateToken.getAttribute2Value();
        if (!attributes.isEmpty()) {
            result = result + "[" + JOINER.join(this.myTemplateToken.getAttribute2Value()) + "]";
        }
        return "Template(" + result + ")";
    }
}

