/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MulOperationNode
extends ZenCodingNode {
    private final ZenCodingNode myLeftOperand;
    private final int myRightOperand;

    public MulOperationNode(ZenCodingNode leftOperand, int rightOperand) {
        this.myLeftOperand = leftOperand;
        this.myRightOperand = rightOperand;
    }

    public ZenCodingNode getLeftOperand() {
        return this.myLeftOperand;
    }

    public int getRightOperand() {
        return this.myRightOperand;
    }

    @Override
    @NotNull
    public List<GenerationNode> expand(int numberInIteration, int totalIterations, String surroundedText, CustomTemplateCallback callback, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        ArrayList<GenerationNode> result = new ArrayList<GenerationNode>();
        for (int i = 0; i < this.myRightOperand; ++i) {
            result.addAll(this.myLeftOperand.expand(i, this.myRightOperand, surroundedText, callback, insertSurroundedTextAtTheEnd, parent));
        }
        ArrayList<GenerationNode> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/MulOperationNode", "expand"));
        }
        return arrayList;
    }

    public String toString() {
        return "*";
    }
}

