/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.XmlEmmetParser;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGeneratorImpl;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ZenCodingGenerator {
    private static final ExtensionPointName<ZenCodingGenerator> EP_NAME = new ExtensionPointName("com.intellij.xml.zenCodingGenerator");
    private static final TokenSet VALID_LEAF_TYPES = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_DATA_CHARACTERS, XmlTokenType.XML_CHAR_ENTITY_REF});

    public abstract TemplateImpl generateTemplate(@NotNull TemplateToken var1, boolean var2, @NotNull PsiElement var3);

    @Nullable
    public TemplateImpl createTemplateByKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/generators/ZenCodingGenerator", "createTemplateByKey"));
        }
        return null;
    }

    public abstract boolean isMyContext(@NotNull PsiElement var1, boolean var2);

    @Nullable
    public String getSuffix() {
        return null;
    }

    public abstract boolean isAppliedByDefault(@NotNull PsiElement var1);

    public abstract boolean isEnabled();

    public static List<ZenCodingGenerator> getInstances() {
        ArrayList<ZenCodingGenerator> generators = new ArrayList<ZenCodingGenerator>();
        Collections.addAll(generators, XmlZenCodingGeneratorImpl.INSTANCE);
        Collections.addAll(generators, EP_NAME.getExtensions());
        return generators;
    }

    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/generators/ZenCodingGenerator", "computeTemplateKey"));
        }
        Editor editor = callback.getEditor();
        int currentOffset = editor.getCaretModel().getOffset();
        CharSequence documentText = editor.getDocument().getCharsSequence();
        PsiElement element = callback.getContext();
        int line = editor.getCaretModel().getLogicalPosition().line;
        int lineStart = editor.getDocument().getLineStartOffset(line);
        int elementStart = -1;
        do {
            int startOffset;
            String key;
            PsiElement e = element;
            while (e instanceof LeafPsiElement && VALID_LEAF_TYPES.contains(((LeafPsiElement)e).getElementType()) || e instanceof PsiWhiteSpace || e instanceof PsiErrorElement) {
                elementStart = e.getTextRange().getStartOffset();
                e = e.getPrevSibling();
            }
            if (elementStart < 0 || (key = ZenCodingGenerator.computeKey(startOffset = Math.max(elementStart, lineStart), currentOffset, documentText)) == null) continue;
            while (key.length() > 0 && !ZenCodingTemplate.checkTemplateKey(key, callback, this)) {
                key = key.substring(1);
            }
            if (key.length() <= 0) continue;
            return key;
        } while ((element = element.getParent()) != null && elementStart > lineStart);
        return null;
    }

    @Nullable
    protected static String computeKey(int startOffset, int currentOffset, CharSequence documentText) {
        int index;
        if (currentOffset < startOffset || startOffset > documentText.length() || currentOffset > documentText.length()) {
            return null;
        }
        String s = ((Object)documentText.subSequence(startOffset, currentOffset)).toString();
        for (index = 0; index < s.length() && Character.isWhitespace(s.charAt(index)); ++index) {
        }
        String key = s.substring(index);
        int lastWhitespaceIndex = -1;
        int lastQuoteIndex = -1;
        int lastApostropheIndex = -1;
        boolean inBrackets = false;
        int bracesStack = 0;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (lastQuoteIndex >= 0 || lastApostropheIndex >= 0) {
                if (c == '\"') {
                    lastQuoteIndex = -1;
                    continue;
                }
                if (c != '\'') continue;
                lastApostropheIndex = -1;
                continue;
            }
            if (Character.isWhitespace(c)) {
                lastWhitespaceIndex = i;
                continue;
            }
            if (c == '\"') {
                lastQuoteIndex = i;
                continue;
            }
            if (c == '\'') {
                lastApostropheIndex = i;
                continue;
            }
            if (c == '[') {
                inBrackets = true;
                continue;
            }
            if (c == ']' && inBrackets) {
                lastWhitespaceIndex = -1;
                inBrackets = false;
                continue;
            }
            if (c == '{') {
                ++bracesStack;
                continue;
            }
            if (c != '}' || bracesStack <= 0 || --bracesStack != 0) continue;
            lastWhitespaceIndex = -1;
        }
        if (lastQuoteIndex >= 0 || lastApostropheIndex >= 0) {
            int max = Math.max(lastQuoteIndex, lastApostropheIndex);
            return max < key.length() - 1 ? key.substring(max) : null;
        }
        if (lastWhitespaceIndex >= 0 && lastWhitespaceIndex < key.length() - 1) {
            return key.substring(lastWhitespaceIndex + 1);
        }
        return key;
    }

    @NotNull
    public EmmetParser createParser(List<ZenCodingToken> tokens, CustomTemplateCallback callback, ZenCodingGenerator generator, boolean surroundWithTemplate) {
        XmlEmmetParser xmlEmmetParser = new XmlEmmetParser(tokens, callback, generator, surroundWithTemplate);
        if (xmlEmmetParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/generators/ZenCodingGenerator", "createParser"));
        }
        return xmlEmmetParser;
    }

    @Nullable
    public UnnamedConfigurable createConfigurable() {
        return null;
    }

    public boolean hasCompletionItem() {
        return false;
    }
}

