/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlZenCodingGenerator
extends ZenCodingGenerator {
    @Override
    public TemplateImpl generateTemplate(@NotNull TemplateToken token, boolean hasChildren, @NotNull PsiElement context) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "generateTemplate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "generateTemplate"));
        }
        String s = this.toString(token, hasChildren, context);
        TemplateImpl template = token.getTemplate().copy();
        template.setString(s);
        return template;
    }

    @Override
    public TemplateImpl createTemplateByKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "createTemplateByKey"));
        }
        StringBuilder builder = new StringBuilder("<");
        builder.append(key).append('>');
        if (!HtmlUtil.isSingleHtmlTag(key)) {
            builder.append("$END$</").append(key).append('>');
        }
        return new TemplateImpl("", builder.toString(), "");
    }

    @NotNull
    private String toString(@NotNull TemplateToken token, boolean hasChildren, @NotNull PsiElement context) {
        XmlTag tag;
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "toString"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "toString"));
        }
        XmlFile file = token.getFile();
        XmlDocument document = file.getDocument();
        if (document != null && (tag = document.getRootTag()) != null) {
            String string = this.toString(tag, token.getAttribute2Value(), hasChildren, context);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "toString"));
            }
            return string;
        }
        String string = file.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "toString"));
        }
        return string;
    }

    public abstract String toString(@NotNull XmlTag var1, @NotNull List<Pair<String, String>> var2, boolean var3, @NotNull PsiElement var4);

    @NotNull
    public abstract String buildAttributesString(@NotNull List<Pair<String, String>> var1, boolean var2, int var3, int var4, @Nullable String var5);

    @Override
    public abstract boolean isMyContext(@NotNull PsiElement var1, boolean var2);
}

