/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.filters.SingleLineEmmetFilter;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Ref;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class EmmetAbbreviationCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/completion/EmmetAbbreviationCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/emmet/completion/EmmetAbbreviationCompletionProvider", "addCompletions"));
        }
        if (!this.isAvailable(parameters)) {
            return;
        }
        ZenCodingGenerator generator = this.getGenerator();
        if (!generator.isMyContext(parameters.getPosition(), false) || !generator.isAppliedByDefault(parameters.getPosition())) {
            return;
        }
        ZenCodingTemplate zenCodingTemplate = (ZenCodingTemplate)CustomLiveTemplate.EP_NAME.findExtension(ZenCodingTemplate.class);
        if (zenCodingTemplate == null) {
            return;
        }
        PsiFile file = parameters.getPosition().getContainingFile();
        Editor editor = parameters.getEditor();
        String completionPrefix = result.getPrefixMatcher().getPrefix();
        String templatePrefix = LiveTemplateCompletionContributor.findLiveTemplatePrefix(file, editor, completionPrefix);
        if (LiveTemplateCompletionContributor.findApplicableTemplate(file, parameters.getOffset(), templatePrefix) != null) {
            result.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().startsWith(templatePrefix));
            return;
        }
        final Ref generatedTemplate = new Ref();
        CustomTemplateCallback callback = new CustomTemplateCallback(editor, file, false){

            @Override
            public void deleteTemplateKey(String key) {
            }

            @Override
            public void startTemplate(Template template, Map<String, String> predefinedValues, TemplateEditingListener listener) {
                if (template instanceof TemplateImpl && !((TemplateImpl)template).isDeactivated()) {
                    generatedTemplate.set((Object)((TemplateImpl)template));
                }
            }
        };
        LinkedList extraFilters = ContainerUtil.newLinkedList((Object[])new SingleLineEmmetFilter[]{new SingleLineEmmetFilter()});
        ZenCodingTemplate.expand(templatePrefix, callback, null, generator, extraFilters, false);
        if (!generatedTemplate.isNull()) {
            result = result.withPrefixMatcher(templatePrefix);
            TemplateImpl template = (TemplateImpl)generatedTemplate.get();
            template.setKey(templatePrefix);
            template.setDescription(template.getTemplateText());
            result.addElement((LookupElement)this.createLookupElement(zenCodingTemplate, template));
            result.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().startsWith(templatePrefix));
        }
    }

    protected LiveTemplateLookupElement createLookupElement(@NotNull CustomLiveTemplateBase customLiveTemplate, @NotNull TemplateImpl template) {
        if (customLiveTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/completion/EmmetAbbreviationCompletionProvider", "createLookupElement"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/emmet/completion/EmmetAbbreviationCompletionProvider", "createLookupElement"));
        }
        return new CustomLiveTemplateLookupElement(customLiveTemplate, template.getKey(), template.getKey(), template.getDescription(), true, true);
    }

    protected abstract ZenCodingGenerator getGenerator();

    protected boolean isAvailable(CompletionParameters parameters) {
        return parameters.getInvocationCount() == 0;
    }
}

