/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.HtmlTextContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.XmlContextType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XslTextContextType
extends TemplateContextType {
    public XslTextContextType() {
        super("XSL_TEXT", CodeInsightBundle.message((String)"dialog.edit.template.checkbox.xsl.text", (Object[])new Object[0]), XmlContextType.class);
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/XslTextContextType", "isInContext"));
        }
        if (XslTextContextType.isXslOrXsltFile(file)) {
            PsiElement element = file.findElementAt(offset);
            return element == null || HtmlTextContextType.isInContext(element);
        }
        return false;
    }

    public static boolean isXslOrXsltFile(@Nullable PsiFile file) {
        return file != null && file.getFileType() == StdFileTypes.XML && (FileUtilRt.extensionEquals((String)file.getName(), (String)"xsl") || FileUtilRt.extensionEquals((String)file.getName(), (String)"xslt"));
    }
}

