/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FileTypeBasedContextType
extends TemplateContextType {
    private final LanguageFileType myFileType;

    protected FileTypeBasedContextType(@NotNull @NonNls String id, @NotNull String presentableName, @NotNull LanguageFileType fileType) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/FileTypeBasedContextType", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/FileTypeBasedContextType", "<init>"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/FileTypeBasedContextType", "<init>"));
        }
        super(id, presentableName);
        this.myFileType = fileType;
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/FileTypeBasedContextType", "isInContext"));
        }
        return this.myFileType == file.getFileType();
    }

    public SyntaxHighlighter createHighlighter() {
        return SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)this.myFileType, null, null);
    }
}

