/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementationSearcher {
    public static final String SEARCHING_FOR_IMPLEMENTATIONS = CodeInsightBundle.message((String)"searching.for.implementations", (Object[])new Object[0]);

    public PsiElement[] searchImplementations(final Editor editor, final PsiElement element, final int offset) {
        final TargetElementUtilBase targetElementUtil = TargetElementUtilBase.getInstance();
        boolean onRef = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return targetElementUtil.findTargetElement(editor, ImplementationSearcher.getFlags() & 0xFFFFFFF6, offset) == null;
            }
        });
        return this.searchImplementations(element, editor, offset, onRef && (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return targetElementUtil.includeSelfInGotoImplementation(element);
            }
        }) != false, onRef);
    }

    @NotNull
    public PsiElement[] searchImplementations(PsiElement element, Editor editor, int offset, boolean includeSelfAlways, boolean includeSelfIfNoOthers) {
        PsiElement[] psiElementArray;
        if (element == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/ImplementationSearcher", "searchImplementations"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] elements = this.searchDefinitions(element, editor);
        if (elements == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/ImplementationSearcher", "searchImplementations"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (elements.length > 0) {
            PsiElement[] all;
            if (!includeSelfAlways) {
                PsiElement[] psiElementArray2 = this.filterElements(element, elements, offset);
                if (psiElementArray2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/ImplementationSearcher", "searchImplementations"));
                }
                return psiElementArray2;
            }
            if (element.getTextRange() != null) {
                all = new PsiElement[elements.length + 1];
                all[0] = element;
                System.arraycopy(elements, 0, all, 1, elements.length);
            } else {
                all = elements;
            }
            PsiElement[] psiElementArray3 = this.filterElements(element, all, offset);
            if (psiElementArray3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/ImplementationSearcher", "searchImplementations"));
            }
            return psiElementArray3;
        }
        if ((includeSelfAlways || includeSelfIfNoOthers) && element.getTextRange() != null) {
            PsiElement[] psiElementArray4 = new PsiElement[1];
            psiElementArray = psiElementArray4;
            psiElementArray4[0] = element;
        } else {
            psiElementArray = PsiElement.EMPTY_ARRAY;
        }
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/ImplementationSearcher", "searchImplementations"));
        }
        return psiElementArray;
    }

    protected static SearchScope getSearchScope(final PsiElement element, final Editor editor) {
        return (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                return TargetElementUtilBase.getInstance().getSearchScope(editor, element);
            }
        });
    }

    @Nullable(value="For the case the search has been cancelled")
    protected PsiElement[] searchDefinitions(final PsiElement element, final Editor editor) {
        final PsiElement[][] result = new PsiElement[1][];
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = (PsiElement[])DefinitionsScopedSearch.search((PsiElement)element, (SearchScope)ImplementationSearcher.getSearchScope(element, editor)).toArray((Object[])PsiElement.EMPTY_ARRAY);
                }
                catch (IndexNotReadyException e) {
                    ImplementationSearcher.dumbModeNotification(element);
                    result[0] = null;
                }
            }
        }, SEARCHING_FOR_IMPLEMENTATIONS, true, element.getProject())) {
            return null;
        }
        return result[0];
    }

    public static void dumbModeNotification(PsiElement element) {
        DumbService.getInstance((Project)element.getProject()).showDumbModeNotification("Implementation information isn't available while indices are built");
    }

    protected PsiElement[] filterElements(PsiElement element, PsiElement[] targetElements, int offset) {
        return targetElements;
    }

    public static int getFlags() {
        return TargetElementUtilBase.getInstance().getDefinitionSearchFlags();
    }

    public static abstract class BackgroundableImplementationSearcher
    extends ImplementationSearcher {
        @Override
        protected PsiElement[] searchDefinitions(PsiElement element, Editor editor) {
            CommonProcessors.CollectProcessor<PsiElement> processor = new CommonProcessors.CollectProcessor<PsiElement>(){

                public boolean process(PsiElement element) {
                    BackgroundableImplementationSearcher.this.processElement(element);
                    return super.process((Object)element);
                }
            };
            try {
                DefinitionsScopedSearch.search((PsiElement)element, (SearchScope)BackgroundableImplementationSearcher.getSearchScope(element, editor)).forEach((Processor)processor);
            }
            catch (IndexNotReadyException e) {
                ImplementationSearcher.dumbModeNotification(element);
                return null;
            }
            return (PsiElement[])processor.toArray((Object[])PsiElement.EMPTY_ARRAY);
        }

        protected abstract void processElement(PsiElement var1);
    }

    public static class FirstImplementationsSearcher
    extends ImplementationSearcher {
        @Override
        protected PsiElement[] searchDefinitions(final PsiElement element, final Editor editor) {
            final PsiElement[][] result = new PsiElement[1][];
            if (this.canShowPopupWithOneItem(element)) {
                return new PsiElement[]{element};
            }
            final PsiElementProcessor.CollectElementsWithLimit collectProcessor = new PsiElementProcessor.CollectElementsWithLimit(2, (Collection)new THashSet());
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    try {
                        DefinitionsScopedSearch.search((PsiElement)element, (SearchScope)ImplementationSearcher.getSearchScope(element, editor)).forEach((Processor)new PsiElementProcessorAdapter<PsiElement>((PsiElementProcessor)collectProcessor){

                            public boolean processInReadAction(PsiElement element) {
                                if (!FirstImplementationsSearcher.this.accept(element)) {
                                    return true;
                                }
                                return super.processInReadAction(element);
                            }
                        });
                        result[0] = collectProcessor.toArray();
                    }
                    catch (IndexNotReadyException e) {
                        ImplementationSearcher.dumbModeNotification(element);
                        result[0] = null;
                    }
                }
            }, SEARCHING_FOR_IMPLEMENTATIONS, true, element.getProject())) {
                return null;
            }
            return result[0];
        }

        protected boolean canShowPopupWithOneItem(PsiElement element) {
            return this.accept(element);
        }

        protected boolean accept(PsiElement element) {
            return true;
        }
    }
}

