/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocPreviewUtil {
    private static final TIntHashSet ALLOWED_LINK_SEPARATORS = new TIntHashSet();
    private static final Comparator<String> REPLACEMENTS_COMPARATOR;

    private DocPreviewUtil() {
    }

    @NotNull
    public static String buildPreview(@NotNull String header, @Nullable String qName, @Nullable String fullText) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/DocPreviewUtil", "buildPreview"));
        }
        if (fullText == null) {
            String string = header;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/DocPreviewUtil", "buildPreview"));
            }
            return string;
        }
        HashMap links = ContainerUtilRt.newHashMap();
        DocPreviewUtil.process(fullText, new LinksCollector(links));
        HashMap toAdd = ContainerUtilRt.newHashMap();
        for (Map.Entry entry : links.entrySet()) {
            String longName;
            String shortName = DocPreviewUtil.parseShortName((String)entry.getKey());
            if (shortName != null) {
                toAdd.put(shortName, entry.getValue());
            }
            if ((longName = DocPreviewUtil.parseLongName((String)entry.getKey(), (String)entry.getValue())) == null) continue;
            toAdd.put(longName, entry.getValue());
        }
        links.putAll(toAdd);
        if (qName != null) {
            links.put(qName, "psi_element://" + qName);
        }
        ArrayList modifiedRanges = ContainerUtilRt.newArrayList();
        ArrayList sortedReplacements = ContainerUtilRt.newArrayList(links.keySet());
        Collections.sort(sortedReplacements, REPLACEMENTS_COMPARATOR);
        StringBuilder buffer = new StringBuilder(header);
        DocPreviewUtil.replace(buffer, "\n", "<br/>", modifiedRanges);
        for (String replaceFrom : sortedReplacements) {
            String visibleName = replaceFrom;
            int i = visibleName.lastIndexOf(46);
            if (i > 0 && i < visibleName.length() - 1) {
                visibleName = visibleName.substring(i + 1);
            }
            DocPreviewUtil.replace(buffer, replaceFrom, String.format("<a href=\"%s\">%s</a>", links.get(replaceFrom), visibleName), modifiedRanges);
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/DocPreviewUtil", "buildPreview"));
        }
        return string;
    }

    @Nullable
    private static String parseShortName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/DocPreviewUtil", "parseShortName"));
        }
        int i = name.lastIndexOf(46);
        return i > 0 && i < name.length() - 1 ? name.substring(i + 1) : null;
    }

    @Nullable
    private static String parseLongName(@NotNull String shortName, @NotNull String address) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/DocPreviewUtil", "parseLongName"));
        }
        if (address == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/navigation/DocPreviewUtil", "parseLongName"));
        }
        String pureAddress = address;
        int i = pureAddress.lastIndexOf("//");
        if (i > 0 && i < pureAddress.length() - 2) {
            pureAddress = pureAddress.substring(i + 2);
        }
        return pureAddress.equals(shortName) || !pureAddress.endsWith(shortName) ? null : pureAddress;
    }

    private static void replace(@NotNull StringBuilder text, @NotNull String replaceFrom, @NotNull String replaceTo, @NotNull List<TextRange> readOnlyChanges) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/DocPreviewUtil", "replace"));
        }
        if (replaceFrom == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/navigation/DocPreviewUtil", "replace"));
        }
        if (replaceTo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/navigation/DocPreviewUtil", "replace"));
        }
        if (readOnlyChanges == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/navigation/DocPreviewUtil", "replace"));
        }
        int i = text.indexOf(replaceFrom);
        while (i >= 0 && i < text.length() - 1) {
            int end = i + replaceFrom.length();
            if (!DocPreviewUtil.intersects(readOnlyChanges, i, end) && ("\n".equals(replaceFrom) || (end >= text.length() || ALLOWED_LINK_SEPARATORS.contains((int)text.charAt(end))) && (i <= 0 || ALLOWED_LINK_SEPARATORS.contains((int)text.charAt(i - 1))))) {
                text.replace(i, end, replaceTo);
                int diff = replaceTo.length() - replaceFrom.length();
                for (int j = 0; j < readOnlyChanges.size(); ++j) {
                    TextRange range = readOnlyChanges.get(j);
                    if (range.getStartOffset() < end) continue;
                    readOnlyChanges.set(j, range.shiftRight(diff));
                }
                readOnlyChanges.add(new TextRange(i, i + replaceTo.length()));
            }
            i = text.indexOf(replaceFrom, i + 1);
        }
    }

    private static boolean intersects(@NotNull List<TextRange> ranges, int start, int end) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/DocPreviewUtil", "intersects"));
        }
        for (TextRange range : ranges) {
            if (!range.intersectsStrict(start, end)) continue;
            return true;
        }
        return false;
    }

    private static int process(@NotNull String text, @NotNull Callback callback) {
        int i;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/DocPreviewUtil", "process"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/navigation/DocPreviewUtil", "process"));
        }
        State state = State.TEXT;
        int dataStartOffset = 0;
        int tagNameStartOffset = 0;
        String tagName = null;
        block5: for (i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (state) {
                case TEXT: {
                    if (c != '<') continue block5;
                    if (i > dataStartOffset && !callback.onText(text.substring(dataStartOffset, i).replace("&nbsp;", " "))) {
                        return dataStartOffset;
                    }
                    dataStartOffset = i;
                    if (i < text.length() - 1 && text.charAt(i + 1) == '/') {
                        state = State.INSIDE_CLOSE_TAG;
                        tagNameStartOffset = ++i + 1;
                        continue block5;
                    }
                    state = State.INSIDE_OPEN_TAG;
                    tagNameStartOffset = i + 1;
                    continue block5;
                }
                case INSIDE_OPEN_TAG: {
                    if (c == ' ') {
                        tagName = text.substring(tagNameStartOffset, i);
                        continue block5;
                    }
                    if (c == '/') {
                        if (i >= text.length() - 1 || text.charAt(i + 1) != '>') continue block5;
                        if (tagName == null) {
                            tagName = text.substring(tagNameStartOffset, i);
                        }
                        if (!callback.onStandaloneTag(tagName, text.substring(dataStartOffset, i + 2))) {
                            return dataStartOffset;
                        }
                        tagName = null;
                        state = State.TEXT;
                        dataStartOffset = ++i + 1;
                        continue block5;
                    }
                    if (c != '>') continue block5;
                    if (tagName == null) {
                        tagName = text.substring(tagNameStartOffset, i);
                    }
                    if (!callback.onOpenTag(tagName, text.substring(dataStartOffset, i + 1))) {
                        return dataStartOffset;
                    }
                    tagName = null;
                    state = State.TEXT;
                    dataStartOffset = i + 1;
                    continue block5;
                }
                case INSIDE_CLOSE_TAG: {
                    if (c != '>') continue block5;
                    if (tagName == null) {
                        tagName = text.substring(tagNameStartOffset, i);
                    }
                    if (!callback.onCloseTag(tagName, text.substring(dataStartOffset, i + 1))) {
                        return dataStartOffset;
                    }
                    tagName = null;
                    state = State.TEXT;
                    dataStartOffset = i + 1;
                }
            }
        }
        if (dataStartOffset < text.length()) {
            callback.onText(text.substring(dataStartOffset, text.length()).replace("&nbsp;", " "));
        }
        return i;
    }

    static {
        ALLOWED_LINK_SEPARATORS.add(44);
        ALLOWED_LINK_SEPARATORS.add(32);
        ALLOWED_LINK_SEPARATORS.add(46);
        ALLOWED_LINK_SEPARATORS.add(59);
        ALLOWED_LINK_SEPARATORS.add(38);
        ALLOWED_LINK_SEPARATORS.add(9);
        ALLOWED_LINK_SEPARATORS.add(10);
        ALLOWED_LINK_SEPARATORS.add(91);
        ALLOWED_LINK_SEPARATORS.add(93);
        ALLOWED_LINK_SEPARATORS.add(40);
        ALLOWED_LINK_SEPARATORS.add(41);
        ALLOWED_LINK_SEPARATORS.add(60);
        ALLOWED_LINK_SEPARATORS.add(62);
        REPLACEMENTS_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(@NotNull String o1, @NotNull String o2) {
                String shortName2;
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/DocPreviewUtil$1", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/navigation/DocPreviewUtil$1", "compare"));
                }
                String shortName1 = this.extractShortName(o1);
                if (!shortName1.equals(shortName2 = this.extractShortName(o2))) {
                    return shortName1.compareTo(shortName2);
                }
                if (o1.endsWith(o2)) {
                    return -1;
                }
                if (o2.endsWith(o1)) {
                    return 1;
                }
                return o1.compareTo(o2);
            }

            private String extractShortName(@NotNull String s) {
                if (s == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/DocPreviewUtil$1", "extractShortName"));
                }
                int i = s.lastIndexOf(46);
                return i > 0 && i < s.length() - 1 ? s.substring(i + 1) : s;
            }
        };
    }

    private static class LinksCollector
    implements Callback {
        private static final Pattern HREF_PATTERN = Pattern.compile("href=[\"']([^\"']+)");
        @NotNull
        private final Map<String, String> myLinks;
        private String myHref;

        LinksCollector(@NotNull Map<String, String> links) {
            if (links == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/DocPreviewUtil$LinksCollector", "<init>"));
            }
            this.myLinks = links;
        }

        @Override
        public boolean onOpenTag(@NotNull String name, @NotNull String text) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/DocPreviewUtil$LinksCollector", "onOpenTag"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/navigation/DocPreviewUtil$LinksCollector", "onOpenTag"));
            }
            if (!"a".equals(name)) {
                return true;
            }
            Matcher matcher = HREF_PATTERN.matcher(text);
            if (matcher.find()) {
                this.myHref = matcher.group(1);
            }
            return true;
        }

        @Override
        public boolean onCloseTag(@NotNull String name, @NotNull String text) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/DocPreviewUtil$LinksCollector", "onCloseTag"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/navigation/DocPreviewUtil$LinksCollector", "onCloseTag"));
            }
            if ("a".equals(name)) {
                this.myHref = null;
            }
            return true;
        }

        @Override
        public boolean onStandaloneTag(@NotNull String name, @NotNull String text) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/DocPreviewUtil$LinksCollector", "onStandaloneTag"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/navigation/DocPreviewUtil$LinksCollector", "onStandaloneTag"));
            }
            return true;
        }

        @Override
        public boolean onText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/DocPreviewUtil$LinksCollector", "onText"));
            }
            if (this.myHref != null) {
                this.myLinks.put(text, this.myHref);
                this.myHref = null;
            }
            return true;
        }
    }

    private static interface Callback {
        public boolean onOpenTag(@NotNull String var1, @NotNull String var2);

        public boolean onCloseTag(@NotNull String var1, @NotNull String var2);

        public boolean onStandaloneTag(@NotNull String var1, @NotNull String var2);

        public boolean onText(@NotNull String var1);
    }

    private static enum State {
        TEXT,
        INSIDE_OPEN_TAG,
        INSIDE_CLOSE_TAG;

    }
}

