/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.actions.ChooseItemAction;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class LookupTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result beforeCharTyped(final char charTyped, Project project, final Editor editor, PsiFile file, FileType fileType) {
        LookupElement item;
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (lookup == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (charTyped == ' ' && ChooseItemAction.hasTemplatePrefix(lookup, ' ')) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        CharFilter.Result result = LookupTypedHandler.getLookupAction(charTyped, lookup);
        if (lookup.isLookupDisposed()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!lookup.performGuardedChange(new Runnable(){

            @Override
            public void run() {
                EditorModificationUtil.deleteSelectedText((Editor)editor);
            }
        })) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (result == CharFilter.Result.ADD_TO_PREFIX) {
            CompletionProgressIndicator completion;
            Document document = editor.getDocument();
            long modificationStamp = document.getModificationStamp();
            if (!lookup.performGuardedChange(new Runnable(){

                @Override
                public void run() {
                    EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets((Editor)editor, (String)String.valueOf(charTyped), (boolean)true);
                }
            })) {
                return TypedHandlerDelegate.Result.STOP;
            }
            lookup.appendPrefix(charTyped);
            if (lookup.isStartCompletionWhenNothingMatches() && lookup.getItems().isEmpty()) {
                completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
                if (completion != null) {
                    completion.scheduleRestart();
                } else {
                    AutoPopupController.getInstance(editor.getProject()).scheduleAutoPopup(editor);
                }
            }
            AutoHardWrapHandler.getInstance().wrapLineIfNecessary(editor, DataManager.getInstance().getDataContext((Component)editor.getContentComponent()), modificationStamp);
            completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
            if (completion != null) {
                completion.prefixUpdated();
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        if (result == CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP && lookup.isFocused() && (item = lookup.getCurrentItem()) != null) {
            if (LookupTypedHandler.completeTillTypedCharOccurrence(charTyped, lookup, item)) {
                return TypedHandlerDelegate.Result.STOP;
            }
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByDotEtc");
            lookup.finishLookup(charTyped);
            return TypedHandlerDelegate.Result.STOP;
        }
        lookup.hide();
        TypedHandler.autoPopupCompletion(editor, charTyped, project, file);
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean completeTillTypedCharOccurrence(char charTyped, LookupImpl lookup, LookupElement item) {
        String oldPrefix;
        PrefixMatcher matcher = lookup.itemMatcher(item);
        PrefixMatcher expanded = matcher.cloneWithPrefix((oldPrefix = matcher.getPrefix() + lookup.getAdditionalPrefix()) + charTyped);
        if (expanded.prefixMatches(item)) {
            for (String s : item.getAllLookupStrings()) {
                if (!matcher.prefixMatches(s)) continue;
                int i = -1;
                while ((i = s.indexOf(charTyped, i + 1)) >= 0) {
                    String newPrefix = s.substring(0, i + 1);
                    if (!expanded.prefixMatches(newPrefix)) continue;
                    lookup.replacePrefix(oldPrefix, newPrefix);
                    return true;
                }
            }
        }
        return false;
    }

    static CharFilter.Result getLookupAction(char charTyped, LookupImpl lookup) {
        CharFilter.Result filtersDecision = LookupTypedHandler.getFiltersDecision(charTyped, lookup);
        LookupElement currentItem = lookup.getCurrentItem();
        if (currentItem != null && charTyped != ' ') {
            String postfix = lookup.getAdditionalPrefix() + charTyped;
            PrefixMatcher matcher = lookup.itemMatcher(currentItem);
            for (String lookupString : currentItem.getAllLookupStrings()) {
                if (!lookupString.startsWith(matcher.getPrefix() + postfix)) continue;
                return CharFilter.Result.ADD_TO_PREFIX;
            }
        }
        if (filtersDecision != null) {
            return filtersDecision;
        }
        throw new AssertionError((Object)("Typed char not handler by char filter: c=" + charTyped + "; prefix=" + currentItem + "; filters=" + Arrays.toString(LookupTypedHandler.getFilters())));
    }

    @Nullable
    private static CharFilter.Result getFiltersDecision(char charTyped, LookupImpl lookup) {
        LookupElement item = lookup.getCurrentItem();
        int prefixLength = item == null ? lookup.getAdditionalPrefix().length() : lookup.itemPattern(item).length();
        for (CharFilter extension : LookupTypedHandler.getFilters()) {
            CharFilter.Result result = extension.acceptChar(charTyped, prefixLength, lookup);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static CharFilter[] getFilters() {
        return (CharFilter[])Extensions.getExtensions(CharFilter.EP_NAME);
    }
}

