/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.ShowHideIntentionIconLookupAction;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.DeferredUserLookupValue;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.Advertiser;
import com.intellij.codeInsight.lookup.impl.CompletionExtender;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupActionsStep;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.LookupOffsets;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.plaf.beg.BegPopupMenuBorder;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.Alarm;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupImpl
extends LightweightHint
implements LookupEx,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.lookup.impl.LookupImpl");
    private final LookupOffsets myOffsets;
    private final Project myProject;
    private final Editor myEditor;
    private final JBList myList;
    private final LookupCellRenderer myCellRenderer;
    private Boolean myPositionedAbove;
    private final List<LookupListener> myListeners;
    private long myStampShown;
    private boolean myShown;
    private boolean myDisposed;
    private boolean myHidden;
    private boolean mySelectionTouched;
    private FocusDegree myFocusDegree;
    private final AsyncProcessIcon myProcessIcon;
    private final JPanel myIconPanel;
    private volatile boolean myCalculating;
    private final Advertiser myAdComponent;
    private volatile String myAdText;
    private volatile int myLookupTextWidth;
    private boolean myChangeGuard;
    private volatile LookupArranger myArranger;
    private LookupArranger myPresentableArranger;
    private final Map<LookupElement, PrefixMatcher> myMatchers;
    private final Map<LookupElement, Font> myCustomFonts;
    private LookupHint myElementHint;
    private final Alarm myHintAlarm;
    private final JLabel mySortingLabel;
    private final JScrollPane myScrollPane;
    final LookupLayeredPane myLayeredPane;
    private final JButton myScrollBarIncreaseButton;
    private boolean myStartCompletionWhenNothingMatches;
    private boolean myResizePending;
    private int myMaximumHeight;
    private boolean myFinishing;
    private boolean myUpdating;
    private final ModalityState myModalityState;
    private static String staticDisposeTrace = null;
    private String disposeTrace;

    public LookupImpl(Project project, Editor editor, @NotNull LookupArranger arranger) {
        if (arranger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/lookup/impl/LookupImpl", "<init>"));
        }
        super(new JPanel(new BorderLayout()));
        this.myList = new JBList((ListModel)new CollectionListModel((Object[])new LookupElement[0])){
            ExpandableItemsHandler<Integer> myExtender;
            {
                this.myExtender = new CompletionExtender((JList)((Object)this));
            }

            protected void processKeyEvent(final KeyEvent e) {
                char keyChar = e.getKeyChar();
                if (keyChar == '\n' || keyChar == '\t') {
                    IdeFocusManager.getInstance((Project)LookupImpl.this.myProject).requestFocus((Component)LookupImpl.this.myEditor.getContentComponent(), true).doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            IdeEventQueue.getInstance().getKeyEventDispatcher().dispatchKeyEvent(e);
                        }
                    });
                    return;
                }
                super.processKeyEvent(e);
            }

            @NotNull
            public ExpandableItemsHandler<Integer> getExpandableItemsHandler() {
                ExpandableItemsHandler<Integer> expandableItemsHandler = this.myExtender;
                if (expandableItemsHandler == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl$1", "getExpandableItemsHandler"));
                }
                return expandableItemsHandler;
            }
        };
        this.myPositionedAbove = null;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myStampShown = 0L;
        this.myShown = false;
        this.myDisposed = false;
        this.myHidden = false;
        this.myFocusDegree = FocusDegree.FOCUSED;
        this.myProcessIcon = new AsyncProcessIcon("Completion progress");
        this.myIconPanel = new JPanel(new BorderLayout());
        this.myLookupTextWidth = 50;
        this.myMatchers = new ConcurrentHashMap(ContainerUtil.identityStrategy());
        this.myCustomFonts = new ConcurrentWeakHashMap(ContainerUtil.identityStrategy());
        this.myElementHint = null;
        this.myHintAlarm = new Alarm();
        this.mySortingLabel = new JLabel();
        this.myLayeredPane = new LookupLayeredPane();
        this.myMaximumHeight = Integer.MAX_VALUE;
        this.disposeTrace = null;
        this.setForceShowAsPopup(true);
        this.setCancelOnClickOutside(false);
        this.setResizable(true);
        AbstractPopup.suppressMacCornerFor((JComponent)this.getComponent());
        this.myProject = project;
        this.myEditor = editor;
        this.myArranger = arranger;
        this.myPresentableArranger = arranger;
        this.myIconPanel.setVisible(false);
        this.myCellRenderer = new LookupCellRenderer(this);
        this.myList.setCellRenderer((ListCellRenderer)this.myCellRenderer);
        this.myList.setFocusable(false);
        this.myList.setFixedCellWidth(50);
        this.myList.setSelectionMode(0);
        this.myList.setBackground(LookupCellRenderer.BACKGROUND_COLOR);
        this.myList.getExpandableItemsHandler();
        this.myScrollBarIncreaseButton = new JButton();
        this.myScrollBarIncreaseButton.setFocusable(false);
        this.myScrollBarIncreaseButton.setRequestFocusEnabled(false);
        this.myScrollPane = new JBScrollPane((Component)this.myList);
        this.myScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        this.myScrollPane.setHorizontalScrollBarPolicy(31);
        this.myScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(13, -1));
        this.myScrollPane.getVerticalScrollBar().setUI((ScrollBarUI)new ButtonlessScrollBarUI(){

            protected JButton createIncreaseButton(int orientation) {
                return LookupImpl.this.myScrollBarIncreaseButton;
            }
        });
        ((Container)this.getComponent()).add((Component)((Object)this.myLayeredPane), "Center");
        this.fixMouseCheaters();
        this.myLayeredPane.mainPanel.add((Component)this.myScrollPane, "Center");
        this.myScrollPane.setBorder(null);
        this.myAdComponent = new Advertiser();
        JComponent adComponent = this.myAdComponent.getAdComponent();
        adComponent.setBorder(new EmptyBorder(0, 1, 1, 2 + AllIcons.Ide.LookupRelevance.getIconWidth()));
        this.myLayeredPane.mainPanel.add((Component)adComponent, "South");
        ((JComponent)this.getComponent()).setBorder(new BegPopupMenuBorder());
        this.myIconPanel.setBackground(Color.LIGHT_GRAY);
        this.myIconPanel.add((Component)this.myProcessIcon);
        this.myOffsets = new LookupOffsets(editor);
        CollectionListModel<LookupElement> model = this.getListModel();
        this.addEmptyItem(model);
        this.updateListHeight((ListModel)model);
        this.addListeners();
        this.mySortingLabel.setBorder(new LineBorder((Color)new JBColor(Color.LIGHT_GRAY, JBColor.background())));
        this.mySortingLabel.setOpaque(true);
        new ChangeLookupSorting().installOn(this.mySortingLabel);
        this.updateSorting();
        this.myModalityState = ModalityState.stateForComponent((Component)this.getComponent());
    }

    private CollectionListModel<LookupElement> getListModel() {
        return (CollectionListModel)this.myList.getModel();
    }

    private void fixMouseCheaters() {
        this.getComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                final ActionCallback done = IdeFocusManager.getInstance((Project)LookupImpl.this.myProject).requestFocus((Component)LookupImpl.this.myEditor.getContentComponent(), true);
                IdeFocusManager.getInstance((Project)LookupImpl.this.myProject).typeAheadUntil(done);
                new Alarm((Disposable)LookupImpl.this).addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (!done.isDone()) {
                            done.setDone();
                        }
                    }
                }, 300, LookupImpl.this.myModalityState);
            }
        });
    }

    void updateSorting() {
        boolean lexi = UISettings.getInstance().SORT_LOOKUP_ELEMENTS_LEXICOGRAPHICALLY;
        this.mySortingLabel.setIcon(lexi ? AllIcons.Ide.LookupAlphanumeric : AllIcons.Ide.LookupRelevance);
        this.mySortingLabel.setToolTipText(lexi ? "Click to sort variants by relevance" : "Click to sort variants alphabetically");
        this.resort(false);
    }

    public void setArranger(LookupArranger arranger) {
        this.myArranger = arranger;
    }

    public FocusDegree getFocusDegree() {
        return this.myFocusDegree;
    }

    public boolean isFocused() {
        return this.getFocusDegree() == FocusDegree.FOCUSED;
    }

    public void setFocusDegree(FocusDegree focusDegree) {
        this.myFocusDegree = focusDegree;
    }

    public boolean isCalculating() {
        return this.myCalculating;
    }

    public void setCalculating(boolean calculating) {
        this.myCalculating = calculating;
        Runnable setVisible = new Runnable(){

            @Override
            public void run() {
                LookupImpl.this.myIconPanel.setVisible(LookupImpl.this.myCalculating);
            }
        };
        if (this.myCalculating) {
            new Alarm((Disposable)this).addRequest(setVisible, 100, this.myModalityState);
        } else {
            setVisible.run();
        }
        if (calculating) {
            this.myProcessIcon.resume();
        } else {
            this.myProcessIcon.suspend();
        }
    }

    public void markSelectionTouched() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        this.mySelectionTouched = true;
        this.myList.repaint();
    }

    public void setSelectionTouched(boolean selectionTouched) {
        this.mySelectionTouched = selectionTouched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resort(boolean addAgain) {
        List<LookupElement> items = this.getItems();
        JBList jBList = this.myList;
        synchronized (jBList) {
            this.myPresentableArranger.prefixChanged(this);
            this.getListModel().removeAll();
        }
        if (addAgain) {
            for (LookupElement item : items) {
                this.addItem(item, this.itemMatcher(item));
            }
        }
        this.refreshUi(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(LookupElement item, PrefixMatcher matcher) {
        this.myMatchers.put(item, matcher);
        LookupElementPresentation presentation = this.updateLookupWidth(item);
        JBList jBList = this.myList;
        synchronized (jBList) {
            this.myArranger.addElement(this, item, presentation);
        }
    }

    public LookupElementPresentation updateLookupWidth(LookupElement item) {
        LookupElementPresentation presentation = LookupImpl.renderItemApproximately(item);
        Font customFont = this.myCellRenderer.getFontAbleToDisplay(presentation);
        if (customFont != null) {
            this.myCustomFonts.put(item, customFont);
        }
        int maxWidth = this.myCellRenderer.updateMaximumWidth(presentation, item);
        this.myLookupTextWidth = Math.max(maxWidth, this.myLookupTextWidth);
        return presentation;
    }

    @Nullable
    public Font getCustomFont(LookupElement item, boolean bold) {
        Font font = this.myCustomFonts.get(item);
        return font == null ? null : (bold ? font.deriveFont(1) : font);
    }

    public void requestResize() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myResizePending = true;
    }

    public Collection<LookupElementAction> getActionsFor(LookupElement element) {
        CollectConsumer consumer = new CollectConsumer();
        for (LookupActionProvider provider : (LookupActionProvider[])LookupActionProvider.EP_NAME.getExtensions()) {
            provider.fillActions(element, this, (Consumer<LookupElementAction>)consumer);
        }
        if (!consumer.getResult().isEmpty()) {
            consumer.consume((Object)new ShowHideIntentionIconLookupAction());
        }
        return consumer.getResult();
    }

    public JList getList() {
        return this.myList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LookupElement> getItems() {
        JBList jBList = this.myList;
        synchronized (jBList) {
            return ContainerUtil.findAll((Collection)this.getListModel().toList(), (Condition)new Condition<LookupElement>(){

                public boolean value(LookupElement element) {
                    return !(element instanceof EmptyLookupItem);
                }
            });
        }
    }

    public void setAdvertisementText(@Nullable String text) {
        this.myAdText = text;
        if (StringUtil.isNotEmpty((String)text)) {
            this.addAdvertisement(text, null);
        }
    }

    public String getAdvertisementText() {
        return this.myAdText;
    }

    public String getAdditionalPrefix() {
        return this.myOffsets.getAdditionalPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendPrefix(char c) {
        this.checkValid();
        this.myOffsets.appendPrefix(c);
        JBList jBList = this.myList;
        synchronized (jBList) {
            this.myPresentableArranger.prefixChanged(this);
        }
        this.requestResize();
        this.refreshUi(false, true);
        this.ensureSelectionVisible(true);
    }

    public void setStartCompletionWhenNothingMatches(boolean startCompletionWhenNothingMatches) {
        this.myStartCompletionWhenNothingMatches = startCompletionWhenNothingMatches;
    }

    public boolean isStartCompletionWhenNothingMatches() {
        return this.myStartCompletionWhenNothingMatches;
    }

    public void ensureSelectionVisible(boolean forceTopSelection) {
        int firstVisibleIndex;
        if (this.isSelectionVisible() && !forceTopSelection) {
            return;
        }
        if (!forceTopSelection) {
            ListScrollingUtil.ensureIndexIsVisible((JList)this.myList, (int)this.myList.getSelectedIndex(), (int)1);
            return;
        }
        int top = this.myList.getSelectedIndex();
        if (top > 0) {
            --top;
        }
        if ((firstVisibleIndex = this.myList.getFirstVisibleIndex()) == top) {
            return;
        }
        ListScrollingUtil.ensureRangeIsVisible((JList)this.myList, (int)top, (int)(top + this.myList.getLastVisibleIndex() - firstVisibleIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean truncatePrefix(boolean preserveSelection) {
        boolean shouldUpdate;
        if (!this.myOffsets.truncatePrefix()) {
            return false;
        }
        if (preserveSelection) {
            this.markSelectionTouched();
        }
        JBList jBList = this.myList;
        synchronized (jBList) {
            shouldUpdate = this.myPresentableArranger == this.myArranger;
            this.myPresentableArranger.prefixChanged(this);
        }
        this.requestResize();
        if (shouldUpdate) {
            this.refreshUi(false, true);
            this.ensureSelectionVisible(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateList(boolean onExplicitAction, boolean reused) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        this.checkValid();
        CollectionListModel<LookupElement> listModel = this.getListModel();
        JBList jBList = this.myList;
        synchronized (jBList) {
            Pair<List<LookupElement>, Integer> pair = this.myPresentableArranger.arrangeItems(this, onExplicitAction || reused);
            List items = (List)pair.first;
            Integer toSelect = (Integer)pair.second;
            if (toSelect == null || toSelect < 0 || items.size() > 0 && toSelect >= items.size()) {
                LOG.error("Arranger " + this.myPresentableArranger + " returned invalid selection index=" + toSelect + "; items=" + items);
            }
            this.myOffsets.checkMinPrefixLengthChanges(items, this);
            List oldModel = listModel.toList();
            listModel.removeAll();
            if (!items.isEmpty()) {
                listModel.add(items);
            } else {
                this.addEmptyItem(listModel);
            }
            this.updateListHeight((ListModel)listModel);
            this.myList.setSelectedIndex(toSelect.intValue());
            return !ContainerUtil.equalsIdentity((List)oldModel, (List)items);
        }
    }

    private boolean isSelectionVisible() {
        return ListScrollingUtil.isIndexFullyVisible((JList)this.myList, (int)this.myList.getSelectedIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkReused() {
        JBList jBList = this.myList;
        synchronized (jBList) {
            if (this.myPresentableArranger != this.myArranger) {
                this.myPresentableArranger = this.myArranger;
                this.myOffsets.clearAdditionalPrefix();
                this.myPresentableArranger.prefixChanged(this);
                return true;
            }
            return false;
        }
    }

    private void updateListHeight(ListModel model) {
        this.myList.setFixedCellHeight(this.myCellRenderer.getListCellRendererComponent((JList)this.myList, model.getElementAt((int)0), (int)0, (boolean)false, (boolean)false).getPreferredSize().height);
        this.myList.setVisibleRowCount(Math.min(model.getSize(), UISettings.getInstance().MAX_LOOKUP_LIST_HEIGHT));
    }

    private void addEmptyItem(CollectionListModel<LookupElement> model) {
        EmptyLookupItem item = new EmptyLookupItem(this.myCalculating ? " " : LangBundle.message("completion.no.suggestions", new Object[0]), false);
        this.myMatchers.put((LookupElement)item, new CamelHumpMatcher(""));
        model.add((Object)item);
        this.updateLookupWidth((LookupElement)item);
        this.requestResize();
    }

    private static LookupElementPresentation renderItemApproximately(LookupElement item) {
        LookupElementPresentation p = new LookupElementPresentation();
        item.renderElement(p);
        return p;
    }

    @NotNull
    public String itemPattern(@NotNull LookupElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemPattern"));
        }
        String prefix = this.itemMatcher(element).getPrefix();
        String additionalPrefix = this.getAdditionalPrefix();
        String string = additionalPrefix.isEmpty() ? prefix : prefix + additionalPrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemPattern"));
        }
        return string;
    }

    @NotNull
    public PrefixMatcher itemMatcher(@NotNull LookupElement item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemMatcher"));
        }
        PrefixMatcher matcher = this.itemMatcherNullable(item);
        if (matcher == null) {
            throw new AssertionError((Object)("Item not in lookup: item=" + item + "; lookup items=" + this.getItems()));
        }
        PrefixMatcher prefixMatcher = matcher;
        if (prefixMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemMatcher"));
        }
        return prefixMatcher;
    }

    public PrefixMatcher itemMatcherNullable(LookupElement item) {
        return this.myMatchers.get(item);
    }

    private Rectangle calculatePosition() {
        JRootPane rootPane;
        Dimension dim = ((JComponent)this.getComponent()).getPreferredSize();
        int lookupStart = this.getLookupStart();
        if (lookupStart < 0 || lookupStart > this.myEditor.getDocument().getTextLength()) {
            LOG.error(lookupStart + "; offset=" + this.myEditor.getCaretModel().getOffset() + "; element=" + this.getPsiElement());
        }
        LogicalPosition pos = this.myEditor.offsetToLogicalPosition(lookupStart);
        Point location = this.myEditor.logicalPositionToXY(pos);
        location.y += this.myEditor.getLineHeight();
        location.x -= this.myCellRenderer.getIconIndent() + ((JComponent)this.getComponent()).getInsets().left;
        SwingUtilities.convertPointToScreen(location, this.myEditor.getContentComponent());
        Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Point)location);
        if (!this.isPositionedAboveCaret()) {
            int shiftLow = screenRectangle.height - (location.y + dim.height);
            this.myPositionedAbove = shiftLow < 0 && shiftLow < location.y - dim.height && location.y >= dim.height;
        }
        if (this.isPositionedAboveCaret()) {
            location.y -= dim.height + this.myEditor.getLineHeight();
            if (pos.line == 0) {
                ++location.y;
            }
        }
        if (!screenRectangle.contains(location)) {
            location = ScreenUtil.findNearestPointOnBorder((Rectangle)screenRectangle, (Point)location);
        }
        if ((rootPane = this.myEditor.getComponent().getRootPane()) == null) {
            LOG.error(this.myEditor.isDisposed() + "; shown=" + this.myShown + "; disposed=" + this.myDisposed + "; editorShowing=" + this.myEditor.getContentComponent().isShowing());
        }
        Rectangle candidate = new Rectangle(location, dim);
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)candidate);
        SwingUtilities.convertPointFromScreen(location, rootPane.getLayeredPane());
        return new Rectangle(location.x, location.y, dim.width, candidate.height);
    }

    public void finishLookup(char completionChar) {
        this.finishLookup(completionChar, (LookupElement)this.myList.getSelectedValue());
    }

    public void finishLookup(char completionChar, final @Nullable LookupElement item) {
        boolean writableOk;
        if (item == null || item instanceof EmptyLookupItem || item.getObject() instanceof DeferredUserLookupValue && item.as(LookupItem.CLASS_CONDITION_KEY) != null && !((DeferredUserLookupValue)item.getObject()).handleUserSelection((LookupItem)item.as(LookupItem.CLASS_CONDITION_KEY), this.myProject)) {
            this.doHide(false, true);
            this.fireItemSelected(null, completionChar);
            return;
        }
        if (this.myDisposed) {
            return;
        }
        PsiFile file = this.getPsiFile();
        boolean bl = writableOk = file == null || FileModificationService.getInstance().prepareFileForWrite(file);
        if (this.myDisposed) {
            return;
        }
        if (!writableOk) {
            this.doHide(false, true);
            this.fireItemSelected(null, completionChar);
            return;
        }
        final String prefix = this.itemPattern(item);
        boolean plainMatch = ContainerUtil.or((Iterable)item.getAllLookupStrings(), (Condition)new Condition<String>(){

            public boolean value(String s) {
                return StringUtil.containsIgnoreCase((String)s, (String)prefix);
            }
        });
        if (!plainMatch) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.camelHumps");
        }
        this.myFinishing = true;
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LookupImpl.this.myEditor.getDocument().startGuardedBlockChecking();
                try {
                    LookupImpl.this.insertLookupString(item, LookupImpl.this.getPrefixLength(item));
                }
                finally {
                    LookupImpl.this.myEditor.getDocument().stopGuardedBlockChecking();
                }
            }
        });
        if (this.myDisposed) {
            return;
        }
        this.doHide(false, true);
        this.fireItemSelected(item, completionChar);
    }

    public int getPrefixLength(LookupElement item) {
        return this.myOffsets.getPrefixLength(item, this);
    }

    private void insertLookupString(LookupElement item, final int prefix) {
        final Document document = this.myEditor.getDocument();
        final String lookupString = this.getCaseCorrectedLookupString(item);
        if (this.myEditor.getSelectionModel().hasBlockSelection()) {
            LogicalPosition blockStart = this.myEditor.getSelectionModel().getBlockStart();
            LogicalPosition blockEnd = this.myEditor.getSelectionModel().getBlockEnd();
            assert (blockStart != null && blockEnd != null);
            int minLine = Math.min(blockStart.line, blockEnd.line);
            int maxLine = Math.max(blockStart.line, blockEnd.line);
            int minColumn = Math.min(blockStart.column, blockEnd.column);
            int maxColumn = Math.max(blockStart.column, blockEnd.column);
            int caretLine = document.getLineNumber(this.myEditor.getCaretModel().getOffset());
            for (int line = minLine; line <= maxLine; ++line) {
                int end;
                int bs = this.myEditor.logicalPositionToOffset(new LogicalPosition(line, minColumn));
                int start = bs - prefix;
                if (start > (end = this.myEditor.logicalPositionToOffset(new LogicalPosition(line, maxColumn)))) {
                    LOG.error("bs=" + bs + "; start=" + start + "; end=" + end + "; blockStart=" + blockStart + "; blockEnd=" + blockEnd + "; line=" + line + "; len=" + (document.getLineEndOffset(line) - document.getLineStartOffset(line)));
                }
                document.replaceString(start, end, (CharSequence)lookupString);
            }
            LogicalPosition start = new LogicalPosition(minLine, minColumn - prefix);
            LogicalPosition end = new LogicalPosition(maxLine, start.column + lookupString.length());
            this.myEditor.getSelectionModel().setBlockSelection(start, end);
            this.myEditor.getCaretModel().moveToLogicalPosition(new LogicalPosition(caretLine, end.column));
        } else {
            this.myEditor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    EditorModificationUtil.deleteSelectedText((Editor)LookupImpl.this.myEditor);
                    int caretOffset = LookupImpl.this.myEditor.getCaretModel().getOffset();
                    int lookupStart = caretOffset - prefix;
                    int len = document.getTextLength();
                    LOG.assertTrue(lookupStart >= 0 && lookupStart <= len, (Object)("ls: " + lookupStart + " caret: " + caretOffset + " prefix:" + prefix + " doc: " + len));
                    LOG.assertTrue(caretOffset >= 0 && caretOffset <= len, (Object)("co: " + caretOffset + " doc: " + len));
                    document.replaceString(lookupStart, caretOffset, (CharSequence)lookupString);
                    int offset = lookupStart + lookupString.length();
                    LookupImpl.this.myEditor.getCaretModel().moveToOffset(offset);
                    LookupImpl.this.myEditor.getSelectionModel().removeSelection();
                }
            });
        }
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    private String getCaseCorrectedLookupString(LookupElement item) {
        String lookupString = item.getLookupString();
        if (item.isCaseSensitive()) {
            return lookupString;
        }
        String prefix = this.itemPattern(item);
        int length = prefix.length();
        if (length == 0 || !StringUtil.startsWithIgnoreCase((String)lookupString, (String)prefix)) {
            return lookupString;
        }
        boolean isAllLower = true;
        boolean isAllUpper = true;
        boolean sameCase = true;
        for (int i = 0; i < length && (isAllLower || isAllUpper || sameCase); ++i) {
            char c = prefix.charAt(i);
            boolean isLower = Character.isLowerCase(c);
            boolean isUpper = Character.isUpperCase(c);
            if (!isLower && !isUpper) continue;
            isAllLower = isAllLower && isLower;
            isAllUpper = isAllUpper && isUpper;
            sameCase = sameCase && isLower == Character.isLowerCase(lookupString.charAt(i));
        }
        if (sameCase) {
            return lookupString;
        }
        if (isAllLower) {
            return lookupString.toLowerCase();
        }
        if (isAllUpper) {
            return StringUtil.toUpperCase((String)lookupString);
        }
        return lookupString;
    }

    public int getLookupStart() {
        return this.myOffsets.getLookupStart(this.disposeTrace);
    }

    public int getLookupOriginalStart() {
        return this.myOffsets.getLookupOriginalStart();
    }

    public boolean performGuardedChange(Runnable change) {
        return this.performGuardedChange(change, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performGuardedChange(Runnable change, @Nullable String debug) {
        boolean result;
        this.checkValid();
        assert (!this.myChangeGuard) : "already in change";
        this.myEditor.getDocument().startGuardedBlockChecking();
        this.myChangeGuard = true;
        try {
            result = this.myOffsets.performGuardedChange(change, debug);
        }
        finally {
            this.myEditor.getDocument().stopGuardedBlockChecking();
            this.myChangeGuard = false;
        }
        if (!result || this.myDisposed) {
            this.hide();
            return false;
        }
        if (this.isVisible()) {
            this.updateLookupLocation();
        }
        this.checkValid();
        return true;
    }

    @Override
    public boolean vetoesHiding() {
        return this.myChangeGuard;
    }

    public boolean isAvailableToUser() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myShown;
        }
        return this.isVisible();
    }

    public boolean isShown() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        return this.myShown;
    }

    public boolean showLookup() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkValid();
        LOG.assertTrue(!this.myShown);
        this.myShown = true;
        this.myStampShown = System.currentTimeMillis();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (!this.myEditor.getContentComponent().isShowing()) {
            this.hide();
            return false;
        }
        this.myAdComponent.showRandomText();
        ((JComponent)this.getComponent()).setBorder(null);
        this.updateScrollbarVisibility();
        Rectangle bounds = this.calculatePosition();
        this.myMaximumHeight = bounds.height;
        Point p = bounds.getLocation();
        HintManagerImpl.getInstanceImpl().showEditorHint((LightweightHint)this, this.myEditor, p, 129, 0, false, HintManagerImpl.createHintHint(this.myEditor, p, this, (short)2).setAwtTooltip(false));
        if (!this.isVisible()) {
            this.hide();
            return false;
        }
        LOG.assertTrue(this.myList.isShowing(), (Object)("!showing, disposed=" + this.myDisposed));
        return true;
    }

    public boolean mayBeNoticed() {
        return this.myStampShown > 0L && System.currentTimeMillis() - this.myStampShown > 300L;
    }

    private void addListeners() {
        this.myEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (!LookupImpl.this.myChangeGuard && !LookupImpl.this.myFinishing) {
                    LookupImpl.this.hide();
                }
            }
        }, (Disposable)this);
        CaretAdapter caretListener = new CaretAdapter(){

            public void caretPositionChanged(CaretEvent e) {
                if (!LookupImpl.this.myChangeGuard && !LookupImpl.this.myFinishing) {
                    LookupImpl.this.hide();
                }
            }
        };
        SelectionListener selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                if (!LookupImpl.this.myChangeGuard && !LookupImpl.this.myFinishing) {
                    LookupImpl.this.hide();
                }
            }
        };
        EditorMouseAdapter mouseListener = new EditorMouseAdapter(){

            public void mouseClicked(EditorMouseEvent e) {
                e.consume();
                LookupImpl.this.hide();
            }
        };
        this.myEditor.getCaretModel().addCaretListener((CaretListener)caretListener);
        this.myEditor.getSelectionModel().addSelectionListener(selectionListener);
        this.myEditor.addEditorMouseListener((EditorMouseListener)mouseListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable((CaretListener)caretListener, selectionListener, (EditorMouseListener)mouseListener){
            final /* synthetic */ CaretListener val$caretListener;
            final /* synthetic */ SelectionListener val$selectionListener;
            final /* synthetic */ EditorMouseListener val$mouseListener;
            {
                this.val$caretListener = caretListener;
                this.val$selectionListener = selectionListener;
                this.val$mouseListener = editorMouseListener;
            }

            public void dispose() {
                LookupImpl.this.myEditor.getCaretModel().removeCaretListener(this.val$caretListener);
                LookupImpl.this.myEditor.getSelectionModel().removeSelectionListener(this.val$selectionListener);
                LookupImpl.this.myEditor.removeEditorMouseListener(this.val$mouseListener);
            }
        });
        JComponent editorComponent = this.myEditor.getContentComponent();
        if (editorComponent.isShowing()) {
            Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)editorComponent, new Activatable(){

                public void showNotify() {
                }

                public void hideNotify() {
                    LookupImpl.this.hideLookup(false);
                }
            }));
        }
        this.myList.addListSelectionListener(new ListSelectionListener(){
            private LookupElement oldItem = null;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LookupImpl.this.myHintAlarm.cancelAllRequests();
                LookupElement item = LookupImpl.this.getCurrentItem();
                if (this.oldItem != item && !LookupImpl.this.myList.isEmpty()) {
                    LookupImpl.this.fireCurrentItemChanged(item);
                    if (LookupImpl.this.myDisposed) {
                        return;
                    }
                    this.oldItem = item;
                }
                if (item != null) {
                    LookupImpl.this.updateHint(item);
                }
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/impl/LookupImpl$16", "onClick"));
                }
                LookupImpl.this.setFocusDegree(FocusDegree.FOCUSED);
                LookupImpl.this.markSelectionTouched();
                if (clickCount == 2) {
                    CommandProcessor.getInstance().executeCommand(LookupImpl.this.myProject, new Runnable(){

                        @Override
                        public void run() {
                            LookupImpl.this.finishLookup('\n');
                        }
                    }, "", null);
                }
                return true;
            }
        }.installOn((Component)this.myList);
        final Alarm alarm = new Alarm((Disposable)this);
        this.myScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!LookupImpl.this.myShown || LookupImpl.this.myUpdating || LookupImpl.this.myDisposed) {
                    return;
                }
                alarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        LookupImpl.this.refreshUi(false, false);
                    }
                }, 300, LookupImpl.this.myModalityState);
            }
        });
    }

    private void updateHint(@NotNull LookupElement item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/impl/LookupImpl", "updateHint"));
        }
        this.checkValid();
        if (this.myElementHint != null) {
            this.myLayeredPane.remove(this.myElementHint);
            this.myElementHint = null;
            JRootPane rootPane = ((JComponent)this.getComponent()).getRootPane();
            if (rootPane != null) {
                rootPane.revalidate();
                rootPane.repaint();
            }
        }
        if (!this.isFocused()) {
            return;
        }
        Collection<LookupElementAction> actions = this.getActionsFor(item);
        if (!actions.isEmpty()) {
            this.myHintAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    assert (!LookupImpl.this.myDisposed);
                    if (!ShowHideIntentionIconLookupAction.shouldShowLookupHint() || ((CompletionExtender)LookupImpl.this.myList.getExpandableItemsHandler()).isShowing()) {
                        return;
                    }
                    LookupImpl.this.myElementHint = new LookupHint();
                    LookupImpl.this.myLayeredPane.add(LookupImpl.this.myElementHint, 20, 0);
                    LookupImpl.this.myLayeredPane.layoutHint();
                }
            }, 500, this.myModalityState);
        }
    }

    @Nullable
    public LookupElement getCurrentItem() {
        LookupElement item = (LookupElement)this.myList.getSelectedValue();
        return item instanceof EmptyLookupItem ? null : item;
    }

    @Override
    public void setCurrentItem(LookupElement item) {
        this.markSelectionTouched();
        this.myList.setSelectedValue((Object)item, false);
    }

    public void addLookupListener(LookupListener listener) {
        this.myListeners.add(listener);
    }

    public void removeLookupListener(LookupListener listener) {
        this.myListeners.remove(listener);
    }

    public Rectangle getCurrentItemBounds() {
        Rectangle itmBounds;
        int index = this.myList.getSelectedIndex();
        if (index < 0) {
            LOG.error("No selected element, size=" + this.getListModel().getSize() + "; items" + this.getItems());
        }
        if ((itmBounds = this.myList.getCellBounds(index, index)) == null) {
            LOG.error("No bounds for " + index + "; size=" + this.getListModel().getSize());
            return null;
        }
        Point layeredPanePoint = SwingUtilities.convertPoint((Component)this.myList, itmBounds.x, itmBounds.y, this.getComponent());
        itmBounds.x = layeredPanePoint.x;
        itmBounds.y = layeredPanePoint.y;
        return itmBounds;
    }

    public void fireItemSelected(@Nullable LookupElement item, char completionChar) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, item, completionChar);
            for (LookupListener listener : this.myListeners) {
                try {
                    listener.itemSelected(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    private void fireLookupCanceled(boolean explicitly) {
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, explicitly);
            for (LookupListener listener : this.myListeners) {
                try {
                    listener.lookupCanceled(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    private void fireCurrentItemChanged(LookupElement item) {
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, item, '\u0000');
            for (LookupListener listener : this.myListeners) {
                listener.currentItemChanged(event);
            }
        }
    }

    public boolean fillInCommonPrefix(boolean explicitlyInvoked) {
        LookupElement item;
        int i;
        if (explicitlyInvoked) {
            this.setFocusDegree(FocusDegree.FOCUSED);
        }
        if (explicitlyInvoked && this.myCalculating) {
            return false;
        }
        if (!explicitlyInvoked && this.mySelectionTouched) {
            return false;
        }
        CollectionListModel<LookupElement> listModel = this.getListModel();
        if (listModel.getSize() <= 1) {
            return false;
        }
        if (listModel.getSize() == 0) {
            return false;
        }
        LookupElement firstItem = (LookupElement)listModel.getElementAt(0);
        if (listModel.getSize() == 1 && firstItem instanceof EmptyLookupItem) {
            return false;
        }
        PrefixMatcher firstItemMatcher = this.itemMatcher(firstItem);
        String oldPrefix = firstItemMatcher.getPrefix();
        String presentPrefix = oldPrefix + this.getAdditionalPrefix();
        String commonPrefix = this.getCaseCorrectedLookupString(firstItem);
        for (i = 1; i < listModel.getSize(); ++i) {
            item = (LookupElement)listModel.getElementAt(i);
            if (item instanceof EmptyLookupItem) {
                return false;
            }
            if (!oldPrefix.equals(this.itemMatcher(item).getPrefix())) {
                return false;
            }
            String lookupString = this.getCaseCorrectedLookupString(item);
            int length = Math.min(commonPrefix.length(), lookupString.length());
            if (length < commonPrefix.length()) {
                commonPrefix = commonPrefix.substring(0, length);
            }
            for (int j = 0; j < length; ++j) {
                if (commonPrefix.charAt(j) == lookupString.charAt(j)) continue;
                commonPrefix = lookupString.substring(0, j);
                break;
            }
            if (commonPrefix.length() != 0 && commonPrefix.length() >= presentPrefix.length()) continue;
            return false;
        }
        if (commonPrefix.equals(presentPrefix)) {
            return false;
        }
        for (i = 0; i < listModel.getSize(); ++i) {
            item = (LookupElement)listModel.getElementAt(i);
            if (this.itemMatcher(item).cloneWithPrefix(commonPrefix).prefixMatches(item)) continue;
            return false;
        }
        this.myOffsets.setInitialPrefix(presentPrefix, explicitlyInvoked);
        this.replacePrefix(presentPrefix, commonPrefix);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replacePrefix(final String presentPrefix, final String newPrefix) {
        if (!this.performGuardedChange(new Runnable(){

            @Override
            public void run() {
                EditorModificationUtil.deleteSelectedText((Editor)LookupImpl.this.myEditor);
                int offset = LookupImpl.this.myEditor.getCaretModel().getOffset();
                int start = offset - presentPrefix.length();
                LookupImpl.this.myEditor.getDocument().replaceString(start, offset, (CharSequence)newPrefix);
                HashMap<LookupElement, PrefixMatcher> newMatchers = new HashMap<LookupElement, PrefixMatcher>();
                for (LookupElement item : LookupImpl.this.getItems()) {
                    PrefixMatcher matcher;
                    if (!item.isValid() || !(matcher = LookupImpl.this.itemMatcher(item).cloneWithPrefix(newPrefix)).prefixMatches(item)) continue;
                    newMatchers.put(item, matcher);
                }
                LookupImpl.this.myMatchers.clear();
                LookupImpl.this.myMatchers.putAll(newMatchers);
                LookupImpl.this.myOffsets.clearAdditionalPrefix();
                LookupImpl.this.myEditor.getCaretModel().moveToOffset(start + newPrefix.length());
            }
        })) {
            return;
        }
        JBList jBList = this.myList;
        synchronized (jBList) {
            this.myPresentableArranger.prefixChanged(this);
        }
        this.refreshUi(true, true);
    }

    @Nullable
    public PsiFile getPsiFile() {
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
    }

    public boolean isCompletion() {
        return this.myArranger instanceof CompletionLookupArranger;
    }

    public PsiElement getPsiElement() {
        PsiFile file = this.getPsiFile();
        if (file == null) {
            return null;
        }
        int offset = this.getLookupStart();
        if (offset > 0) {
            return file.findElementAt(offset - 1);
        }
        return file.findElementAt(0);
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    public boolean isPositionedAboveCaret() {
        return this.myPositionedAbove != null && this.myPositionedAbove != false;
    }

    public boolean isSelectionTouched() {
        return this.mySelectionTouched;
    }

    public List<String> getAdvertisements() {
        return this.myAdComponent.getAdvertisements();
    }

    @Override
    public void hide() {
        this.hideLookup(true);
    }

    public void hideLookup(boolean explicitly) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myHidden) {
            return;
        }
        this.doHide(true, explicitly);
    }

    private void doHide(boolean fireCanceled, boolean explicitly) {
        if (this.myDisposed) {
            LOG.error(this.disposeTrace);
        } else {
            this.myHidden = true;
            try {
                super.hide();
                Disposer.dispose((Disposable)this);
                assert (this.myDisposed);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (fireCanceled) {
            this.fireLookupCanceled(explicitly);
        }
    }

    public void restorePrefix() {
        this.myOffsets.restorePrefix(this.getLookupStart());
    }

    public static String getLastLookupDisposeTrace() {
        return staticDisposeTrace;
    }

    public void dispose() {
        assert (ApplicationManager.getApplication().isDispatchThread());
        assert (this.myHidden);
        if (this.myDisposed) {
            LOG.error(this.disposeTrace);
            return;
        }
        this.myOffsets.disposeMarkers();
        Disposer.dispose((Disposable)this.myProcessIcon);
        Disposer.dispose((Disposable)this.myHintAlarm);
        this.myDisposed = true;
        staticDisposeTrace = this.disposeTrace = DebugUtil.currentStackTrace() + "\n============";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUi(boolean mayCheckReused, boolean onExplicitAction) {
        assert (!this.myUpdating);
        this.myUpdating = true;
        try {
            this.doRefreshUi(mayCheckReused, onExplicitAction);
        }
        finally {
            this.myUpdating = false;
        }
    }

    private void doRefreshUi(boolean mayCheckReused, boolean onExplicitAction) {
        boolean reused = mayCheckReused && this.checkReused();
        boolean selectionVisible = this.isSelectionVisible();
        boolean itemsChanged = this.updateList(onExplicitAction, reused);
        if (this.isVisible()) {
            LOG.assertTrue(!ApplicationManager.getApplication().isUnitTestMode());
            if (this.myEditor.getComponent().getRootPane() == null) {
                return;
            }
            this.updateScrollbarVisibility();
            if (this.myResizePending || itemsChanged) {
                this.myMaximumHeight = Integer.MAX_VALUE;
            }
            Rectangle rectangle = this.calculatePosition();
            this.myMaximumHeight = rectangle.height;
            if (this.myResizePending || itemsChanged) {
                this.myResizePending = false;
                this.pack();
            }
            HintManagerImpl.updateLocation(this, this.myEditor, rectangle.getLocation());
            if (reused || selectionVisible || onExplicitAction) {
                this.ensureSelectionVisible(false);
            }
        }
    }

    private void updateLookupLocation() {
        Rectangle rectangle = this.calculatePosition();
        this.myMaximumHeight = rectangle.height;
        HintManagerImpl.updateLocation(this, this.myEditor, rectangle.getLocation());
    }

    private void updateScrollbarVisibility() {
        boolean showSorting = this.isCompletion() && this.getListModel().getSize() >= 3;
        this.mySortingLabel.setVisible(showSorting);
        this.myScrollPane.setVerticalScrollBarPolicy(showSorting ? 22 : 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markReused() {
        this.myAdComponent.clearAdvertisements();
        JBList jBList = this.myList;
        synchronized (jBList) {
            this.myArranger = this.myArranger.createEmptyCopy();
        }
        this.requestResize();
    }

    public void addAdvertisement(final @NotNull String text, final @Nullable Color bgColor) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/impl/LookupImpl", "addAdvertisement"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!LookupImpl.this.myDisposed) {
                    LookupImpl.this.myAdComponent.addAdvertisement(text, bgColor);
                    if (LookupImpl.this.myShown) {
                        LookupImpl.this.requestResize();
                        LookupImpl.this.refreshUi(false, false);
                    }
                }
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, this.myModalityState);
        }
    }

    public boolean isLookupDisposed() {
        return this.myDisposed;
    }

    public void checkValid() {
        if (this.myDisposed) {
            throw new AssertionError((Object)("Disposed at: " + this.disposeTrace));
        }
    }

    @Override
    public void showItemPopup(JBPopup hint) {
        Rectangle bounds = this.getCurrentItemBounds();
        hint.show(new RelativePoint(this.getComponent(), new Point(bounds.x + bounds.width, bounds.y)));
    }

    @Override
    public boolean showElementActions() {
        if (!this.isVisible()) {
            return false;
        }
        LookupElement element = this.getCurrentItem();
        if (element == null) {
            return false;
        }
        Collection<LookupElementAction> actions = this.getActionsFor(element);
        if (actions.isEmpty()) {
            return false;
        }
        this.showItemPopup((JBPopup)JBPopupFactory.getInstance().createListPopup((ListPopupStep)new LookupActionsStep(actions, this, element)));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<LookupElement, StringBuilder> getRelevanceStrings() {
        JBList jBList = this.myList;
        synchronized (jBList) {
            return this.myPresentableArranger.getRelevanceStrings();
        }
    }

    public static enum FocusDegree {
        FOCUSED,
        SEMI_FOCUSED,
        UNFOCUSED;

    }

    private class ChangeLookupSorting
    extends ClickListener {
        private ChangeLookupSorting() {
        }

        public boolean onClick(@NotNull MouseEvent e, int clickCount) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/impl/LookupImpl$ChangeLookupSorting", "onClick"));
            }
            DataContext context = DataManager.getInstance().getDataContext((Component)LookupImpl.this.mySortingLabel);
            DefaultActionGroup group = new DefaultActionGroup();
            group.add(this.createSortingAction(true));
            group.add(this.createSortingAction(false));
            JBPopupFactory.getInstance().createActionGroupPopup("Change sorting", (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).showInBestPositionFor(context);
            return true;
        }

        private AnAction createSortingAction(boolean checked) {
            boolean currentSetting = UISettings.getInstance().SORT_LOOKUP_ELEMENTS_LEXICOGRAPHICALLY;
            final boolean newSetting = checked ? currentSetting : !currentSetting;
            return new AnAction(newSetting ? "Sort lexicographically" : "Sort by relevance", null, checked ? PlatformIcons.CHECK_ICON : null){

                public void actionPerformed(AnActionEvent e) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.changeSorting");
                    UISettings.getInstance().SORT_LOOKUP_ELEMENTS_LEXICOGRAPHICALLY = newSetting;
                    LookupImpl.this.updateSorting();
                }
            };
        }
    }

    private class LookupHint
    extends JLabel {
        private final Border INACTIVE_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        private final Border ACTIVE_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(1, 1, 1, 1));

        private LookupHint() {
            this.setOpaque(false);
            this.setBorder(this.INACTIVE_BORDER);
            this.setIcon(AllIcons.Actions.IntentionBulb);
            String acceleratorsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
            if (acceleratorsText.length() > 0) {
                this.setToolTipText(CodeInsightBundle.message((String)"lightbulb.tooltip", (Object[])new Object[]{acceleratorsText}));
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    LookupHint.this.setBorder(LookupHint.this.ACTIVE_BORDER);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    LookupHint.this.setBorder(LookupHint.this.INACTIVE_BORDER);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!e.isPopupTrigger() && e.getButton() == 1) {
                        LookupImpl.this.showElementActions();
                    }
                }
            });
        }
    }

    private class LookupLayeredPane
    extends JBLayeredPane {
        final JPanel mainPanel = new JPanel(new BorderLayout());

        private LookupLayeredPane() {
            this.add(this.mainPanel, 0, 0);
            this.add(LookupImpl.this.myIconPanel, 42, 0);
            this.add(LookupImpl.this.mySortingLabel, 10, 0);
            this.setLayout((LayoutManager)new AbstractLayoutManager(){

                public Dimension preferredLayoutSize(@Nullable Container parent) {
                    int maxCellWidth = LookupImpl.this.myLookupTextWidth + LookupImpl.this.myCellRenderer.getIconIndent();
                    int scrollBarWidth = ((LookupImpl)LookupImpl.this).myScrollPane.getPreferredSize().width - ((LookupImpl)LookupImpl.this).myScrollPane.getViewport().getPreferredSize().width;
                    int listWidth = Math.min(scrollBarWidth + maxCellWidth, UISettings.getInstance().MAX_LOOKUP_WIDTH2);
                    Dimension adSize = LookupImpl.this.myAdComponent.getAdComponent().getPreferredSize();
                    int panelHeight = ((LookupImpl)LookupImpl.this).myList.getPreferredScrollableViewportSize().height + adSize.height;
                    if (LookupImpl.this.getListModel().getSize() > LookupImpl.this.myList.getVisibleRowCount() && LookupImpl.this.myList.getVisibleRowCount() >= 5) {
                        panelHeight -= LookupImpl.this.myList.getFixedCellHeight() / 2;
                    }
                    return new Dimension(Math.max(listWidth, adSize.width), Math.min(panelHeight, LookupImpl.this.myMaximumHeight));
                }

                public void layoutContainer(Container parent) {
                    Dimension size = LookupLayeredPane.this.getSize();
                    LookupLayeredPane.this.mainPanel.setSize(size);
                    LookupLayeredPane.this.mainPanel.validate();
                    if (!LookupImpl.this.myResizePending) {
                        int listHeight;
                        Dimension preferredSize = this.preferredLayoutSize(null);
                        if (preferredSize.width != size.width) {
                            UISettings.getInstance().MAX_LOOKUP_WIDTH2 = Math.max(500, size.width);
                        }
                        if ((listHeight = LookupImpl.this.myList.getLastVisibleIndex() - LookupImpl.this.myList.getFirstVisibleIndex() + 1) != LookupImpl.this.getListModel().getSize() && listHeight != LookupImpl.this.myList.getVisibleRowCount() && preferredSize.height != size.height) {
                            UISettings.getInstance().MAX_LOOKUP_LIST_HEIGHT = Math.max(5, listHeight);
                        }
                    }
                    LookupImpl.this.myList.setFixedCellWidth(LookupImpl.this.myScrollPane.getViewport().getWidth());
                    LookupLayeredPane.this.layoutStatusIcons();
                    LookupLayeredPane.this.layoutHint();
                }
            });
        }

        private void layoutStatusIcons() {
            int adHeight = ((LookupImpl)LookupImpl.this).myAdComponent.getAdComponent().getPreferredSize().height;
            Dimension buttonSize = adHeight > 0 || !LookupImpl.this.mySortingLabel.isVisible() ? new Dimension(0, 0) : new Dimension(AllIcons.Ide.LookupRelevance.getIconWidth(), AllIcons.Ide.LookupRelevance.getIconHeight());
            LookupImpl.this.myScrollBarIncreaseButton.setPreferredSize(buttonSize);
            LookupImpl.this.myScrollBarIncreaseButton.setMinimumSize(buttonSize);
            LookupImpl.this.myScrollBarIncreaseButton.setMaximumSize(buttonSize);
            JScrollBar scrollBar = LookupImpl.this.myScrollPane.getVerticalScrollBar();
            scrollBar.revalidate();
            scrollBar.repaint();
            Dimension iconSize = LookupImpl.this.myProcessIcon.getPreferredSize();
            LookupImpl.this.myIconPanel.setBounds(this.getWidth() - iconSize.width - (scrollBar.isVisible() ? scrollBar.getWidth() : 0), 0, iconSize.width, iconSize.height);
            Dimension sortSize = LookupImpl.this.mySortingLabel.getPreferredSize();
            Point sbLocation = SwingUtilities.convertPoint(scrollBar, 0, 0, (Component)((Object)LookupImpl.this.myLayeredPane));
            int sortHeight = Math.max(adHeight, ((LookupImpl)LookupImpl.this).mySortingLabel.getPreferredSize().height);
            LookupImpl.this.mySortingLabel.setBounds(sbLocation.x, this.getHeight() - sortHeight, sortSize.width, sortHeight);
        }

        void layoutHint() {
            if (LookupImpl.this.myElementHint != null && LookupImpl.this.getCurrentItem() != null) {
                Rectangle bounds = LookupImpl.this.getCurrentItemBounds();
                LookupImpl.this.myElementHint.setSize(LookupImpl.this.myElementHint.getPreferredSize());
                JScrollBar sb = LookupImpl.this.myScrollPane.getVerticalScrollBar();
                LookupImpl.this.myElementHint.setLocation(new Point(bounds.x + bounds.width - LookupImpl.this.myElementHint.getWidth() + (sb.isVisible() ? sb.getWidth() : 0), bounds.y));
            }
        }
    }
}

