/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.config.ResourceTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntentionActionMetaData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData");
    @NotNull
    private final IntentionAction myAction;
    private final ClassLoader myIntentionLoader;
    private final String myDescriptionDirectoryName;
    @NotNull
    public final String[] myCategory;
    private TextDescriptor[] myExampleUsagesBefore;
    private TextDescriptor[] myExampleUsagesAfter;
    private TextDescriptor myDescription;
    private URL myDirURL;
    @NonNls
    private static final String BEFORE_TEMPLATE_PREFIX = "before";
    @NonNls
    private static final String AFTER_TEMPLATE_PREFIX = "after";
    @NonNls
    static final String EXAMPLE_USAGE_URL_SUFFIX = ".template";
    @NonNls
    private static final String DESCRIPTION_FILE_NAME = "description.html";
    @NonNls
    private static final String INTENTION_DESCRIPTION_FOLDER = "intentionDescriptions";

    public IntentionActionMetaData(@NotNull IntentionAction action, @Nullable ClassLoader loader, @NotNull String[] category, @NotNull String descriptionDirectoryName) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "<init>"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "<init>"));
        }
        if (descriptionDirectoryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "<init>"));
        }
        this.myExampleUsagesBefore = null;
        this.myExampleUsagesAfter = null;
        this.myDescription = null;
        this.myDirURL = null;
        this.myAction = action;
        this.myIntentionLoader = loader;
        this.myCategory = category;
        this.myDescriptionDirectoryName = descriptionDirectoryName;
    }

    public IntentionActionMetaData(@NotNull IntentionAction action, @NotNull String[] category, TextDescriptor description, TextDescriptor[] exampleUsagesBefore, TextDescriptor[] exampleUsagesAfter) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "<init>"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "<init>"));
        }
        this.myExampleUsagesBefore = null;
        this.myExampleUsagesAfter = null;
        this.myDescription = null;
        this.myDirURL = null;
        this.myAction = action;
        this.myCategory = category;
        this.myExampleUsagesBefore = exampleUsagesBefore;
        this.myExampleUsagesAfter = exampleUsagesAfter;
        this.myDescription = description;
        this.myIntentionLoader = null;
        this.myDescriptionDirectoryName = null;
    }

    public String toString() {
        return this.getFamily();
    }

    @NotNull
    public TextDescriptor[] getExampleUsagesBefore() {
        if (this.myExampleUsagesBefore == null) {
            try {
                this.myExampleUsagesBefore = IntentionActionMetaData.retrieveURLs(this.getDirURL(), BEFORE_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myExampleUsagesBefore == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "getExampleUsagesBefore"));
        }
        return this.myExampleUsagesBefore;
    }

    @NotNull
    public TextDescriptor[] getExampleUsagesAfter() {
        if (this.myExampleUsagesAfter == null) {
            try {
                this.myExampleUsagesAfter = IntentionActionMetaData.retrieveURLs(this.getDirURL(), AFTER_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myExampleUsagesAfter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "getExampleUsagesAfter"));
        }
        return this.myExampleUsagesAfter;
    }

    @NotNull
    public TextDescriptor getDescription() {
        if (this.myDescription == null) {
            try {
                URL dirURL = this.getDirURL();
                URL descriptionURL = new URL(dirURL.toExternalForm() + "/" + DESCRIPTION_FILE_NAME);
                this.myDescription = new ResourceTextDescriptor(descriptionURL);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        TextDescriptor textDescriptor = this.myDescription;
        if (textDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "getDescription"));
        }
        return textDescriptor;
    }

    @NotNull
    private static TextDescriptor[] retrieveURLs(@NotNull URL descriptionDirectory, @NotNull String prefix, @NotNull String suffix) throws MalformedURLException {
        FileType[] fileTypes;
        if (descriptionDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "retrieveURLs"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "retrieveURLs"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "retrieveURLs"));
        }
        ArrayList<ResourceTextDescriptor> urls = new ArrayList<ResourceTextDescriptor>();
        for (FileType fileType : fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            String[] extensions;
            block6: for (String extension : extensions = FileTypeManager.getInstance().getAssociatedExtensions(fileType)) {
                int i = 0;
                while (true) {
                    URL url = new URL(descriptionDirectory.toExternalForm() + "/" + prefix + "." + extension + (i == 0 ? "" : Integer.toString(i)) + suffix);
                    try {
                        InputStream inputStream = url.openStream();
                        inputStream.close();
                        urls.add(new ResourceTextDescriptor(url));
                    }
                    catch (IOException ioe) {
                        continue block6;
                    }
                    ++i;
                }
            }
        }
        if (urls.isEmpty()) {
            String[] children;
            Exception cause = null;
            try {
                URI uri = descriptionDirectory.toURI();
                children = uri.isOpaque() ? null : (String[])ObjectUtils.notNull((Object)new File(uri).list(), (Object)ArrayUtil.EMPTY_STRING_ARRAY);
            }
            catch (URISyntaxException e) {
                cause = e;
                children = null;
            }
            catch (IllegalArgumentException e) {
                cause = e;
                children = null;
            }
            LOG.error("URLs not found for available file types and prefix: '" + prefix + "', suffix: '" + suffix + "';" + " in directory: '" + descriptionDirectory + "'" + (children == null ? "" : "; directory contents: " + Arrays.asList(children)), (Throwable)cause);
            TextDescriptor[] textDescriptorArray = new TextDescriptor[]{};
            if (textDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "retrieveURLs"));
            }
            return textDescriptorArray;
        }
        TextDescriptor[] textDescriptorArray = urls.toArray(new TextDescriptor[urls.size()]);
        if (textDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "retrieveURLs"));
        }
        return textDescriptorArray;
    }

    @Nullable
    private static URL getIntentionDescriptionDirURL(ClassLoader aClassLoader, String intentionFolderName) {
        URL pageURL = aClassLoader.getResource("intentionDescriptions/" + intentionFolderName + "/" + DESCRIPTION_FILE_NAME);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Path:intentionDescriptions/" + intentionFolderName);
            LOG.debug("URL:" + pageURL);
        }
        if (pageURL != null) {
            try {
                String url = pageURL.toExternalForm();
                return UrlClassLoader.internProtocol((URL)new URL(url.substring(0, url.lastIndexOf(47))));
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    private URL getDirURL() {
        if (this.myDirURL == null) {
            this.myDirURL = IntentionActionMetaData.getIntentionDescriptionDirURL(this.myIntentionLoader, this.myDescriptionDirectoryName);
        }
        if (this.myDirURL == null) {
            this.myDirURL = IntentionActionMetaData.getIntentionDescriptionDirURL(this.myIntentionLoader, this.getFamily());
        }
        LOG.assertTrue(this.myDirURL != null, (Object)("Intention Description Dir URL is null: " + this.getFamily() + "; " + this.myDescriptionDirectoryName + ", " + this.myIntentionLoader));
        return this.myDirURL;
    }

    @Nullable
    public PluginId getPluginId() {
        if (this.myIntentionLoader instanceof PluginClassLoader) {
            return ((PluginClassLoader)((Object)this.myIntentionLoader)).getPluginId();
        }
        return null;
    }

    @NotNull
    public String getFamily() {
        String string = this.myAction.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "getFamily"));
        }
        return string;
    }

    @NotNull
    public IntentionAction getAction() {
        IntentionAction intentionAction = this.myAction;
        if (intentionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "getAction"));
        }
        return intentionAction;
    }
}

