/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseColorIntentionAction
extends PsiElementBaseIntentionAction
implements HighPriorityAction {
    protected static final String JAVA_AWT_COLOR = "java.awt.Color";
    protected static final String COLOR_UI_RESOURCE = "javax.swing.plaf.ColorUIResource";

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/BaseColorIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/BaseColorIntentionAction", "isAvailable"));
        }
        if (!((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(PsiNewExpression.class))).accepts((Object)element)) {
            return false;
        }
        PsiNewExpression expression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class, (boolean)false);
        return expression != null && BaseColorIntentionAction.isJavaAwtColor(expression.getClassOrAnonymousClassReference()) && BaseColorIntentionAction.isValueArguments(expression.getArgumentList());
    }

    private static boolean isJavaAwtColor(@Nullable PsiJavaCodeReferenceElement ref) {
        String fqn = BaseColorIntentionAction.getFqn(ref);
        return JAVA_AWT_COLOR.equals(fqn) || COLOR_UI_RESOURCE.equals(fqn);
    }

    @Nullable
    protected static String getFqn(@Nullable PsiJavaCodeReferenceElement ref) {
        PsiElement psiElement;
        PsiReference reference;
        if (ref != null && (reference = ref.getReference()) != null && (psiElement = reference.resolve()) instanceof PsiClass) {
            return ((PsiClass)psiElement).getQualifiedName();
        }
        return null;
    }

    private static boolean isValueArguments(@Nullable PsiExpressionList arguments) {
        if (arguments == null) {
            return false;
        }
        for (PsiExpression argument : arguments.getExpressions()) {
            if (!(argument instanceof PsiReferenceExpression)) continue;
            return false;
        }
        return true;
    }
}

