/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAnnotationPsiFix
extends LocalQuickFixOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.AddAnnotationPsiFix");
    protected final String myAnnotation;
    protected final String[] myAnnotationsToRemove;
    protected final PsiNameValuePair[] myPairs;
    protected final String myText;

    public AddAnnotationPsiFix(@NotNull String fqn, @NotNull PsiModifierListOwner modifierListOwner, @NotNull PsiNameValuePair[] values, String ... annotationsToRemove) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "<init>"));
        }
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "<init>"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "<init>"));
        }
        if (annotationsToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "<init>"));
        }
        super((PsiElement)modifierListOwner);
        this.myAnnotation = fqn;
        this.myPairs = values;
        this.myAnnotationsToRemove = annotationsToRemove;
        this.myText = AddAnnotationPsiFix.calcText(modifierListOwner, this.myAnnotation);
    }

    public static String calcText(PsiModifierListOwner modifierListOwner, @NotNull String annotation) {
        String name;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "calcText"));
        }
        String shortName = annotation.substring(annotation.lastIndexOf(46) + 1);
        if (modifierListOwner instanceof PsiNamedElement && (name = ((PsiNamedElement)modifierListOwner).getName()) != null) {
            FindUsagesProvider provider = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(modifierListOwner.getLanguage());
            return CodeInsightBundle.message((String)"inspection.i18n.quickfix.annotate.element.as", (Object[])new Object[]{provider.getType((PsiElement)modifierListOwner), name, shortName});
        }
        return CodeInsightBundle.message((String)"inspection.i18n.quickfix.annotate.as", (Object[])new Object[]{shortName});
    }

    @Nullable
    public static PsiModifierListOwner getContainer(PsiFile file, int offset) {
        PsiElement target;
        PsiReference reference = file.findReferenceAt(offset);
        if (reference != null && (target = reference.resolve()) instanceof PsiMember) {
            return (PsiMember)target;
        }
        PsiElement element = file.findElementAt(offset);
        PsiModifierListOwner listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class, (boolean)false);
        if (listOwner != null) {
            return listOwner;
        }
        PsiIdentifier psiIdentifier = (PsiIdentifier)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIdentifier.class, (boolean)false);
        if (psiIdentifier != null && psiIdentifier.getParent() instanceof PsiModifierListOwner) {
            return (PsiModifierListOwner)psiIdentifier.getParent();
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "isAvailable"));
        }
        if (!startElement.isValid()) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)startElement)) {
            return false;
        }
        PsiModifierListOwner myModifierListOwner = (PsiModifierListOwner)startElement;
        return !AnnotationUtil.isAnnotated((PsiModifierListOwner)myModifierListOwner, (String)this.myAnnotation, (boolean)false, (boolean)false);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "invoke"));
        }
        PsiModifierListOwner myModifierListOwner = (PsiModifierListOwner)startElement;
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        PsiModifierList modifierList = myModifierListOwner.getModifierList();
        LOG.assertTrue(modifierList != null);
        if (modifierList.findAnnotation(this.myAnnotation) != null) {
            return;
        }
        ExternalAnnotationsManager.AnnotationPlace annotationAnnotationPlace = annotationsManager.chooseAnnotationsPlace((PsiElement)myModifierListOwner);
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.NOWHERE) {
            return;
        }
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.EXTERNAL) {
            for (String fqn : this.myAnnotationsToRemove) {
                annotationsManager.deannotate(myModifierListOwner, fqn);
            }
            annotationsManager.annotateExternally(myModifierListOwner, this.myAnnotation, file, this.myPairs);
        } else {
            PsiFile containingFile = myModifierListOwner.getContainingFile();
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)containingFile)) {
                return;
            }
            AddAnnotationPsiFix.removePhysicalAnnotations(myModifierListOwner, this.myAnnotationsToRemove);
            PsiAnnotation inserted = AddAnnotationPsiFix.addPhysicalAnnotation(this.myAnnotation, this.myPairs, modifierList);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)inserted);
            if (containingFile != file) {
                UndoUtil.markPsiFileForUndo((PsiFile)file);
            }
        }
    }

    public static PsiAnnotation addPhysicalAnnotation(String fqn, PsiNameValuePair[] pairs, PsiModifierList modifierList) {
        PsiAnnotation inserted = modifierList.addAnnotation(fqn);
        for (PsiNameValuePair pair : pairs) {
            inserted.setDeclaredAttributeValue(pair.getName(), pair.getValue());
        }
        return inserted;
    }

    public static void removePhysicalAnnotations(PsiModifierListOwner owner, String ... fqns) {
        for (String fqn : fqns) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{fqn});
            if (annotation == null) continue;
            annotation.delete();
        }
    }

    @NotNull
    public String[] getAnnotationsToRemove() {
        if (this.myAnnotationsToRemove == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/AddAnnotationPsiFix", "getAnnotationsToRemove"));
        }
        return this.myAnnotationsToRemove;
    }
}

