/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.LazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooltipLinkHandlerEP
extends AbstractExtensionPointBean {
    public static final ExtensionPointName<TooltipLinkHandlerEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.codeInsight.linkHandler");
    @Attribute(value="prefix")
    public String prefix;
    @Attribute(value="handlerClass")
    public String handlerClassName;
    private final LazyInstance<TooltipLinkHandler> myHandler = new LazyInstance<TooltipLinkHandler>(){

        protected Class<TooltipLinkHandler> getInstanceClass() throws ClassNotFoundException {
            return TooltipLinkHandlerEP.this.findClass(TooltipLinkHandlerEP.this.handlerClassName);
        }
    };

    public static boolean handleLink(@NotNull String ref, @NotNull Editor editor) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/hint/TooltipLinkHandlerEP", "handleLink"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/hint/TooltipLinkHandlerEP", "handleLink"));
        }
        for (TooltipLinkHandlerEP handlerEP : (TooltipLinkHandlerEP[])Extensions.getExtensions(EP_NAME)) {
            if (!ref.startsWith(handlerEP.prefix)) continue;
            String refSuffix = ref.substring(handlerEP.prefix.length());
            return ((TooltipLinkHandler)handlerEP.myHandler.getValue()).handleLink(refSuffix.replaceAll("<br/>", "\n"), editor);
        }
        return false;
    }

    @Nullable
    public static String getDescription(@NotNull String ref, @NotNull Editor editor) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/hint/TooltipLinkHandlerEP", "getDescription"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/hint/TooltipLinkHandlerEP", "getDescription"));
        }
        for (TooltipLinkHandlerEP handlerEP : (TooltipLinkHandlerEP[])Extensions.getExtensions(EP_NAME)) {
            if (!ref.startsWith(handlerEP.prefix)) continue;
            String refSuffix = ref.substring(handlerEP.prefix.length());
            return ((TooltipLinkHandler)handlerEP.myHandler.getValue()).getDescription(refSuffix, editor);
        }
        return null;
    }
}

