/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoComponent;
import com.intellij.codeInsight.hint.ShowParameterInfoContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.Language;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.LanguageParameterInfo;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import gnu.trove.THashSet;
import java.awt.Point;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowParameterInfoHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/hint/ShowParameterInfoHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/hint/ShowParameterInfoHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/hint/ShowParameterInfoHandler", "invoke"));
        }
        ShowParameterInfoHandler.invoke(project, editor, file, -1, null);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void invoke(Project project, Editor editor, PsiFile file, int lbraceOffset, PsiElement highlightedElement) {
        LookupEx lookup;
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null) {
            return;
        }
        ShowParameterInfoContext context = new ShowParameterInfoContext(editor, project, file, offset, lbraceOffset);
        context.setHighlightedElement(highlightedElement);
        Language language = psiElement.getLanguage();
        ParameterInfoHandler[] handlers = ShowParameterInfoHandler.getHandlers(project, language, file.getViewProvider().getBaseLanguage());
        if (handlers == null) {
            handlers = new ParameterInfoHandler[]{};
        }
        if ((lookup = LookupManager.getInstance(project).getActiveLookup()) != null) {
            LookupElement item = lookup.getCurrentItem();
            if (item != null) {
                for (ParameterInfoHandler handler : handlers) {
                    if (!handler.couldShowInLookup()) continue;
                    Object[] items = handler.getParametersForLookup(item, (ParameterInfoContext)context);
                    if (items != null && items.length > 0) {
                        ShowParameterInfoHandler.showLookupEditorHint(items, editor, project, handler);
                    }
                    return;
                }
            }
            return;
        }
        for (ParameterInfoHandler handler : handlers) {
            Object element = handler.findElementForParameterInfo((CreateParameterInfoContext)context);
            if (element == null) continue;
            handler.showParameterInfo(element, (CreateParameterInfoContext)context);
        }
    }

    private static void showLookupEditorHint(Object[] descriptors, final Editor editor, Project project, ParameterInfoHandler handler) {
        ParameterInfoComponent component = new ParameterInfoComponent(descriptors, editor, handler);
        component.update();
        final LightweightHint hint = new LightweightHint(component);
        hint.setSelectingHint(true);
        final HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        final Pair<Point, Short> pos = ShowParameterInfoContext.chooseBestHintPosition(project, editor, -1, -1, hint, true, (short)6);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!editor.getComponent().isShowing()) {
                    return;
                }
                hintManager.showEditorHint(hint, editor, (Point)pos.getFirst(), 134, 0, false, (Short)pos.getSecond());
            }
        });
    }

    @Nullable
    public static ParameterInfoHandler[] getHandlers(Project project, Language ... languages) {
        THashSet handlers = new THashSet();
        for (Language language : languages) {
            handlers.addAll(DumbService.getInstance((Project)project).filterByDumbAwareness((Collection)LanguageParameterInfo.INSTANCE.allForLanguage(language)));
        }
        if (handlers.isEmpty()) {
            return null;
        }
        return handlers.toArray(new ParameterInfoHandler[handlers.size()]);
    }

    static interface BestLocationPointProvider {
        @NotNull
        public Pair<Point, Short> getBestPointPosition(LightweightHint var1, PsiElement var2, int var3, boolean var4, short var5);
    }
}

