/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.DeclarationRangeHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.MixinExtension;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclarationRangeUtil {
    public static Map<Class, DeclarationRangeHandler> ourDeclarationRangeRegistry = new HashMap<Class, DeclarationRangeHandler>();

    private DeclarationRangeUtil() {
    }

    public static void setDeclarationHandler(@NotNull Class clazz, DeclarationRangeHandler handler) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/hint/DeclarationRangeUtil", "setDeclarationHandler"));
        }
        ourDeclarationRangeRegistry.put(clazz, handler);
    }

    @NotNull
    public static TextRange getDeclarationRange(PsiElement container) {
        TextRange textRange = DeclarationRangeUtil.getPossibleDeclarationAtRange(container);
        assert (textRange != null) : "Declaration range is invalid for " + container.getClass();
        TextRange textRange2 = textRange;
        if (textRange2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/DeclarationRangeUtil", "getDeclarationRange"));
        }
        return textRange2;
    }

    @Nullable
    public static TextRange getPossibleDeclarationAtRange(PsiElement container) {
        DeclarationRangeHandler handler = (DeclarationRangeHandler)MixinExtension.getInstance((ExtensionPointName)DeclarationRangeHandler.EP_NAME, (Object)container);
        if (handler != null) {
            return handler.getDeclarationRange(container);
        }
        for (Class clazz : ourDeclarationRangeRegistry.keySet()) {
            DeclarationRangeHandler handler2;
            if (!clazz.isInstance(container) || (handler2 = ourDeclarationRangeRegistry.get(clazz)) == null) continue;
            return handler2.getDeclarationRange(container);
        }
        return null;
    }
}

