/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class LargeFilesAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/highlighting/LargeFilesAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/highlighting/LargeFilesAnnotator", "annotate"));
        }
        if (element instanceof PsiFile && element.getTextLength() > PersistentFSConstants.getMaxIntellisenseFileSize()) {
            holder.createWarningAnnotation(element, "File size exceeds configured limit (" + PersistentFSConstants.getMaxIntellisenseFileSize() + "). " + "Code insight features are not available.").setFileLevelAnnotation(true);
        }
    }
}

