/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.highlighting.HighlightSuppressedWarningsHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiTreeUtil;

public class HighlightSuppressedWarningsFactory
implements HighlightUsagesHandlerFactory {
    @Override
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(Editor editor, PsiFile file) {
        VirtualFile virtualFile;
        int offset = TargetElementUtilBase.adjustOffset(file, editor.getDocument(), editor.getCaretModel().getOffset());
        PsiElement target = file.findElementAt(offset);
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)target, PsiAnnotation.class);
        if (annotation != null && Comparing.strEqual((String)SuppressWarnings.class.getName(), (String)annotation.getQualifiedName()) && (virtualFile = file.getVirtualFile()) != null && !virtualFile.getFileType().isBinary()) {
            return new HighlightSuppressedWarningsHandler(editor, file, annotation, (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)target, PsiLiteralExpression.class));
        }
        return null;
    }
}

