/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.codeInsight.template.impl.SurroundWithTemplateHandler;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageSurrounders;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class SurroundWithAction
extends BaseCodeInsightAction {
    public SurroundWithAction() {
        this.setEnabledInModalContext(true);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        SurroundWithHandler surroundWithHandler = new SurroundWithHandler();
        if (surroundWithHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/actions/SurroundWithAction", "getHandler"));
        }
        return surroundWithHandler;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/actions/SurroundWithAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/actions/SurroundWithAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/generation/actions/SurroundWithAction", "isValidForFile"));
        }
        Language language = file.getLanguage();
        if (!LanguageSurrounders.INSTANCE.allForLanguage(language).isEmpty()) {
            return true;
        }
        PsiFile baseFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)file);
        if (baseFile != null && baseFile != file && !LanguageSurrounders.INSTANCE.allForLanguage(baseFile.getLanguage()).isEmpty()) {
            return true;
        }
        return !SurroundWithTemplateHandler.getApplicableTemplates(editor, file, true).isEmpty();
    }
}

