/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenerateSuperMethodCallHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.actions.GenerateSuperMethodCallHandler");

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/actions/GenerateSuperMethodCallHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/actions/GenerateSuperMethodCallHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/generation/actions/GenerateSuperMethodCallHandler", "invoke"));
        }
        if (!CodeInsightUtilBase.prepareEditorForWrite(editor)) {
            return;
        }
        PsiMethod method = GenerateSuperMethodCallHandler.canInsertSuper(project, editor, file);
        try {
            PsiMethod template = (PsiMethod)method.copy();
            OverrideImplementUtil.setupMethodBody(template, method, method.getContainingClass());
            PsiStatement superCall = template.getBody().getStatements()[0];
            PsiCodeBlock body = method.getBody();
            PsiElement toGo = body.getLBrace() == null ? body.addBefore((PsiElement)superCall, null) : body.addAfter((PsiElement)superCall, (PsiElement)body.getLBrace());
            toGo = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(toGo);
            editor.getCaretModel().moveToOffset(toGo.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static PsiMethod canInsertSuper(Project project, Editor editor, PsiFile file) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
        if (codeBlock == null) {
            return null;
        }
        if (!(codeBlock.getParent() instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)codeBlock.getParent();
        List superSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : superSignatures) {
            if (superSignature.getMethod().hasModifierProperty("abstract")) continue;
            return method;
        }
        return null;
    }
}

