/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public class GenerateCreateUIHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/actions/GenerateCreateUIHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/actions/GenerateCreateUIHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/generation/actions/GenerateCreateUIHandler", "invoke"));
        }
        PsiElement element = PsiUtilBase.getElementAtCaret((Editor)editor);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        String annotation = "";
        if (PsiUtil.getLanguageLevel((PsiElement)file).isAtLeast(LanguageLevel.JDK_1_5)) {
            annotation = "@SuppressWarnings({\"MethodOverridesStaticMethodOfSuperclass\", \"UnusedDeclaration\"})";
        }
        PsiMethod createUI = factory.createMethodFromText(annotation + "\npublic static javax.swing.plaf.ComponentUI createUI(javax.swing.JComponent c) {" + "\n  return new " + psiClass.getName() + "();\n}", (PsiElement)psiClass);
        PsiMethod newMethod = (PsiMethod)psiClass.add(CodeStyleManager.getInstance((Project)project).reformat((PsiElement)createUI));
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)newMethod);
        PsiReturnStatement returnStatement = (PsiReturnStatement)PsiTreeUtil.findChildOfType((PsiElement)newMethod, PsiReturnStatement.class);
        if (returnStatement != null) {
            int offset = returnStatement.getTextRange().getEndOffset();
            editor.getCaretModel().moveToOffset(offset - 2);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

