/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.generation.DelegateMethodsHandler;
import com.intellij.lang.CodeInsightActions;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class DelegateMethodsAction
extends BaseCodeInsightAction {
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        DelegateMethodsHandler delegateMethodsHandler = new DelegateMethodsHandler();
        if (delegateMethodsHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/actions/DelegateMethodsAction", "getHandler"));
        }
        return delegateMethodsHandler;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/actions/DelegateMethodsAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/actions/DelegateMethodsAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/generation/actions/DelegateMethodsAction", "isValidForFile"));
        }
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset());
        LanguageCodeInsightActionHandler codeInsightActionHandler = (LanguageCodeInsightActionHandler)CodeInsightActions.DELEGATE_METHODS.forLanguage(language);
        if (codeInsightActionHandler != null) {
            return codeInsightActionHandler.isValidFor(editor, file);
        }
        return false;
    }

    @Override
    public void update(AnActionEvent event) {
        if (CodeInsightActions.DELEGATE_METHODS.hasAnyExtensions()) {
            event.getPresentation().setVisible(true);
            super.update(event);
        } else {
            event.getPresentation().setVisible(false);
        }
    }
}

