/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.generation.CommentByBlockCommentHandler;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class CommentByBlockCommentAction
extends BaseCodeInsightAction
implements DumbAware {
    public CommentByBlockCommentAction() {
        this.setEnabledInModalContext(true);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        CommentByBlockCommentHandler commentByBlockCommentHandler = new CommentByBlockCommentHandler();
        if (commentByBlockCommentHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/actions/CommentByBlockCommentAction", "getHandler"));
        }
        return commentByBlockCommentHandler;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/actions/CommentByBlockCommentAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/actions/CommentByBlockCommentAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/generation/actions/CommentByBlockCommentAction", "isValidForFile"));
        }
        FileType fileType = file.getFileType();
        if (fileType instanceof AbstractFileType) {
            return ((AbstractFileType)fileType).getCommenter() != null;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(file.getLanguage());
        if (commenter == null) {
            commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(file.getViewProvider().getBaseLanguage());
        }
        if (commenter == null) {
            return false;
        }
        return commenter.getBlockCommentPrefix() != null && commenter.getBlockCommentSuffix() != null;
    }
}

