/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpandRegionAction
extends EditorAction {
    public ExpandRegionAction() {
        super(new EditorActionHandler(){

            public void execute(Editor editor, DataContext dataContext) {
                ExpandRegionAction.expandRegionAtCaret(editor.getProject(), editor);
            }

            public boolean isEnabled(Editor editor, DataContext dataContext) {
                return super.isEnabled(editor, dataContext) && CommonDataKeys.PROJECT.getData(dataContext) != null;
            }
        });
    }

    public static void expandRegionAtCaret(Project project, @Nullable Editor editor) {
        if (editor == null) {
            return;
        }
        ExpandRegionAction.expandRegionAtOffset(project, editor, editor.getCaretModel().getOffset());
    }

    public static void expandRegionAtOffset(@NotNull Project project, final @NotNull Editor editor, final int offset) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/actions/ExpandRegionAction", "expandRegionAtOffset"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/folding/impl/actions/ExpandRegionAction", "expandRegionAtOffset"));
        }
        CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project);
        foldingManager.updateFoldRegions(editor);
        final int line = editor.getDocument().getLineNumber(offset);
        Runnable processor = new Runnable(){

            @Override
            public void run() {
                FoldRegion region = FoldingUtil.findFoldRegionStartingAtLine(editor, line);
                if (region != null && !region.isExpanded()) {
                    region.setExpanded(true);
                } else {
                    FoldRegion[] regions = FoldingUtil.getFoldRegionsAtOffset(editor, offset);
                    for (int i = regions.length - 1; i >= 0; --i) {
                        region = regions[i];
                        if (region.isExpanded()) continue;
                        region.setExpanded(true);
                        break;
                    }
                }
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(processor);
    }
}

