/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;

public class ExpandAllRegionsAction
extends EditorAction {
    public ExpandAllRegionsAction() {
        super(new EditorActionHandler(){

            public void execute(final Editor editor, DataContext dataContext) {
                Project project = editor.getProject();
                assert (project != null);
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                CodeFoldingManager.getInstance(project).updateFoldRegions(editor);
                editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

                    @Override
                    public void run() {
                        FoldRegion[] regions;
                        boolean anythingDone = false;
                        for (FoldRegion region : regions = editor.getFoldingModel().getAllFoldRegions()) {
                            PsiElement element = EditorFoldingInfo.get(editor).getPsiElement(region);
                            if (region.isExpanded() || element != null && FoldingPolicy.isCollapseByDefault(element)) continue;
                            region.setExpanded(true);
                            anythingDone = true;
                        }
                        if (!anythingDone) {
                            for (FoldRegion region : regions) {
                                region.setExpanded(true);
                            }
                        }
                    }
                });
            }

            public boolean isEnabled(Editor editor, DataContext dataContext) {
                return super.isEnabled(editor, dataContext) && editor.getProject() != null;
            }
        });
    }
}

