/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;

public class CollapseRegionAction
extends EditorAction {
    public CollapseRegionAction() {
        super(new EditorActionHandler(){

            public void execute(final Editor editor, DataContext dataContext) {
                CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(editor.getProject());
                foldingManager.updateFoldRegions(editor);
                final int line = editor.getCaretModel().getLogicalPosition().line;
                Runnable processor = new Runnable(){

                    @Override
                    public void run() {
                        FoldRegion region = FoldingUtil.findFoldRegionStartingAtLine(editor, line);
                        if (region != null && region.isExpanded()) {
                            region.setExpanded(false);
                        } else {
                            FoldRegion[] regions;
                            int offset = editor.getCaretModel().getOffset();
                            for (FoldRegion region1 : regions = FoldingUtil.getFoldRegionsAtOffset(editor, offset)) {
                                if (!region1.isExpanded()) continue;
                                region1.setExpanded(false);
                                break;
                            }
                        }
                    }
                };
                editor.getFoldingModel().runBatchFoldingOperation(processor);
            }

            public boolean isEnabled(Editor editor, DataContext dataContext) {
                return super.isEnabled(editor, dataContext) && editor.getProject() != null;
            }
        });
    }
}

