/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.AbstractElementSignatureProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiNamesElementSignatureProvider
extends AbstractElementSignatureProvider {
    private static final String TYPE_MARKER = "n";
    private static final String TOP_LEVEL_CHILD_MARKER = "!!top";
    private static final String DOC_COMMENT_MARKER = "!!doc";
    private static final String CODE_BLOCK_MARKER = "!!block";

    @Override
    protected PsiElement restoreBySignatureTokens(@NotNull PsiFile file, @NotNull PsiElement parent, @NotNull String type, @NotNull StringTokenizer tokenizer, @Nullable StringBuilder processingInfoStorage) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/PsiNamesElementSignatureProvider", "restoreBySignatureTokens"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/folding/impl/PsiNamesElementSignatureProvider", "restoreBySignatureTokens"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/folding/impl/PsiNamesElementSignatureProvider", "restoreBySignatureTokens"));
        }
        if (tokenizer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/folding/impl/PsiNamesElementSignatureProvider", "restoreBySignatureTokens"));
        }
        if (!TYPE_MARKER.equals(type)) {
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Stopping '%s' provider because given signature doesn't have expected type - can work with '%s' but got '%s'%n", this.getClass().getName(), TYPE_MARKER, type));
            }
            return null;
        }
        String elementMarker = tokenizer.nextToken();
        if (TOP_LEVEL_CHILD_MARKER.equals(elementMarker)) {
            PsiElement result = null;
            for (PsiElement child = file.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof PsiWhiteSpace) continue;
                if (result == null) {
                    result = child;
                    continue;
                }
                if (processingInfoStorage != null) {
                    processingInfoStorage.append(String.format("Stopping '%s' provider because it has top level marker but more than one non white-space child: %s%n", this.getClass().getName(), Arrays.toString(file.getChildren())));
                }
                return null;
            }
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Finished processing of '%s' provider because all of its top-level children have been processed: %s%n", this.getClass().getName(), Arrays.toString(file.getChildren())));
            }
            return result;
        }
        if (DOC_COMMENT_MARKER.equals(elementMarker)) {
            PsiElement candidate = parent.getFirstChild();
            return candidate instanceof PsiComment ? candidate : null;
        }
        if (CODE_BLOCK_MARKER.equals(elementMarker)) {
            for (PsiElement child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
                PsiElement firstChild = child.getFirstChild();
                PsiElement lastChild = child.getLastChild();
                if (firstChild == null || lastChild == null || !"{".equals(firstChild.getText()) || !"}".equals(lastChild.getText())) continue;
                return child;
            }
            return null;
        }
        if (!tokenizer.hasMoreTokens()) {
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Stopping '%s' provider because it has no more data to process%n", this.getClass().getName()));
            }
            return null;
        }
        try {
            int index = Integer.parseInt(tokenizer.nextToken());
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Looking for the child with a name '%s' # %d at the element '%s'%n", elementMarker, index, parent));
            }
            return PsiNamesElementSignatureProvider.restoreElementInternal(parent, PsiNamesElementSignatureProvider.unescape(elementMarker), index, PsiNamedElement.class);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String getSignature(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/PsiNamesElementSignatureProvider", "getSignature"));
        }
        StringBuilder buffer = null;
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            int length = buffer == null ? 0 : buffer.length();
            StringBuilder b = PsiNamesElementSignatureProvider.getSignature(current, buffer);
            if (b == null && buffer != null && current.getParent() instanceof PsiFile && PsiNamesElementSignatureProvider.canResolveTopLevelChild(current)) {
                buffer.append(TYPE_MARKER).append("#").append(TOP_LEVEL_CHILD_MARKER).append(";");
                break;
            }
            buffer = b;
            if (buffer == null || length >= buffer.length()) {
                return null;
            }
            buffer.append(";");
        }
        if (buffer == null) {
            return null;
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    private static boolean canResolveTopLevelChild(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/PsiNamesElementSignatureProvider", "canResolveTopLevelChild"));
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return false;
        }
        for (PsiElement child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiWhiteSpace || child == element) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static StringBuilder getSignature(@NotNull PsiElement element, @Nullable StringBuilder buffer) {
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/PsiNamesElementSignatureProvider", "getSignature"));
        }
        if (element instanceof PsiNamedElement) {
            PsiNamedElement named = (PsiNamedElement)element;
            String name = named.getName();
            if (StringUtil.isEmpty((String)name)) {
                return null;
            }
            int index = PsiNamesElementSignatureProvider.getChildIndex(named, element.getParent(), name, PsiNamedElement.class);
            StringBuilder bufferToUse = buffer;
            if (bufferToUse == null) {
                bufferToUse = new StringBuilder();
            }
            bufferToUse.append(TYPE_MARKER).append("#").append(PsiNamesElementSignatureProvider.escape(name)).append("#").append(index);
            return bufferToUse;
        }
        if (element instanceof PsiComment) {
            parent = element.getParent();
            boolean nestedComment = false;
            if (parent instanceof PsiComment && parent.getTextRange().equals((Object)element.getTextRange())) {
                parent = parent.getParent();
                nestedComment = true;
            }
            if (parent instanceof PsiNamedElement && (nestedComment || parent.getFirstChild() == element)) {
                StringBuilder bufferToUse = buffer;
                if (bufferToUse == null) {
                    bufferToUse = new StringBuilder();
                }
                bufferToUse.append(TYPE_MARKER).append("#").append(DOC_COMMENT_MARKER);
                return bufferToUse;
            }
        }
        if ((parent = element.getParent()) instanceof PsiNamedElement && !(parent instanceof PsiFile)) {
            PsiElement firstChild = element.getFirstChild();
            PsiElement lastChild = element.getLastChild();
            if (firstChild != null && "{".equals(firstChild.getText()) && lastChild != null && "}".equals(lastChild.getText())) {
                StringBuilder bufferToUse = buffer;
                if (bufferToUse == null) {
                    bufferToUse = new StringBuilder();
                }
                bufferToUse.append(TYPE_MARKER).append("#").append(CODE_BLOCK_MARKER);
                return bufferToUse;
            }
        }
        return null;
    }
}

