/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFoldingInfo {
    private static final Key<EditorFoldingInfo> KEY = Key.create((String)"EditorFoldingInfo.KEY");
    private final Map<FoldRegion, SmartPsiElementPointer<?>> myFoldRegionToSmartPointerMap = new THashMap();

    @NotNull
    public static EditorFoldingInfo get(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/EditorFoldingInfo", "get"));
        }
        EditorFoldingInfo info = (EditorFoldingInfo)editor.getUserData(KEY);
        if (info == null) {
            info = new EditorFoldingInfo();
            editor.putUserData(KEY, (Object)info);
        }
        EditorFoldingInfo editorFoldingInfo = info;
        if (editorFoldingInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/EditorFoldingInfo", "get"));
        }
        return editorFoldingInfo;
    }

    @Nullable
    public PsiElement getPsiElement(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/EditorFoldingInfo", "getPsiElement"));
        }
        SmartPsiElementPointer<?> pointer = this.myFoldRegionToSmartPointerMap.get(region);
        if (pointer == null) {
            return null;
        }
        PsiElement element = pointer.getElement();
        return element != null && element.isValid() ? element : null;
    }

    @Nullable
    public TextRange getPsiElementRange(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/EditorFoldingInfo", "getPsiElementRange"));
        }
        PsiElement element = this.getPsiElement(region);
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        boolean isInjected = injectedManager.isInjectedFragment(containingFile);
        TextRange range = element.getTextRange();
        if (isInjected) {
            range = injectedManager.injectedToHost(element, range);
        }
        return range;
    }

    public boolean isLightRegion(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/EditorFoldingInfo", "isLightRegion"));
        }
        return this.myFoldRegionToSmartPointerMap.get(region) == null;
    }

    public void addRegion(@NotNull FoldRegion region, @NotNull SmartPsiElementPointer<?> pointer) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/EditorFoldingInfo", "addRegion"));
        }
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/folding/impl/EditorFoldingInfo", "addRegion"));
        }
        this.myFoldRegionToSmartPointerMap.put(region, pointer);
    }

    public void removeRegion(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/EditorFoldingInfo", "removeRegion"));
        }
        this.myFoldRegionToSmartPointerMap.remove(region);
    }

    public void dispose() {
        for (FoldRegion region : this.myFoldRegionToSmartPointerMap.keySet()) {
            region.dispose();
        }
        this.myFoldRegionToSmartPointerMap.clear();
    }

    public static void resetInfo(@NotNull Editor editor) {
        FoldingModel foldingModel;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/EditorFoldingInfo", "resetInfo"));
        }
        EditorFoldingInfo info = (EditorFoldingInfo)editor.getUserData(KEY);
        if (info != null) {
            info.dispose();
        }
        if ((foldingModel = editor.getFoldingModel()) instanceof FoldingModelEx) {
            ((FoldingModelEx)foldingModel).rebuild();
        }
        editor.putUserData(KEY, null);
    }
}

