/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameterList;
import java.util.ArrayList;
import java.util.List;

public class ListSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiParameterList || e instanceof PsiExpressionList;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        PsiElement[] children = e.getChildren();
        int start = 0;
        int end = 0;
        for (PsiElement child : children) {
            if (!(child instanceof PsiJavaToken)) continue;
            PsiJavaToken token = (PsiJavaToken)child;
            if (token.getTokenType() == JavaTokenType.LPARENTH) {
                start = token.getTextOffset() + 1;
            }
            if (token.getTokenType() != JavaTokenType.RPARENTH) continue;
            end = token.getTextOffset();
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        if (start != 0 && end != 0) {
            result.add(new TextRange(start, end));
        }
        return result;
    }
}

